/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Litmus;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlDynamicParam
extends SqlNode {
    private final int index;

    public SqlDynamicParam(int index, SqlParserPos pos) {
        super(pos);
        this.index = index;
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlDynamicParam(this.index, pos);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.DYNAMIC_PARAM;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.dynamicParam(this.index);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope2) {
        validator.validateDynamicParam(this);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlValidatorScope scope2) {
        return SqlMonotonicity.CONSTANT;
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor2) {
        return visitor2.visit(this);
    }

    @Override
    public boolean equalsDeep(@Nullable SqlNode node, Litmus litmus) {
        if (!(node instanceof SqlDynamicParam)) {
            return litmus.fail("{} != {}", this, node);
        }
        SqlDynamicParam that = (SqlDynamicParam)node;
        if (this.index != that.index) {
            return litmus.fail("{} != {}", this, node);
        }
        return litmus.succeed();
    }
}

