/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Proxy;
import java.util.Locale;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Compatible {
    public static final Compatible INSTANCE = new Factory().create();

    public <T> boolean isRecord(Class<T> var1);

    public static class Factory {
        private static final @Nullable MethodHandle IS_RECORD = Factory.tryGetIsRecordMethod(MethodHandles.lookup());

        Compatible create() {
            return (Compatible)Proxy.newProxyInstance(Compatible.class.getClassLoader(), new Class[]{Compatible.class}, (proxy, method, args2) -> {
                if ("isRecord".equals(method.getName())) {
                    return Factory.isRecord(Objects.requireNonNull(args2[0], "args[0]"));
                }
                return null;
            });
        }

        private static boolean isRecord(Object clazz) {
            if (IS_RECORD == null) {
                return false;
            }
            try {
                return IS_RECORD.invoke(clazz);
            }
            catch (Throwable e) {
                throw new RuntimeException(String.format(Locale.ROOT, "Failed to invoke %s on %s", IS_RECORD, clazz), e);
            }
        }

        private static @Nullable MethodHandle tryGetIsRecordMethod(MethodHandles.Lookup lookup) {
            try {
                MethodType methodType = MethodType.methodType(Boolean.TYPE);
                return lookup.findVirtual(Class.class, "isRecord", methodType);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                return null;
            }
        }
    }
}

