/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMdDistribution;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BuiltInMethod;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EnumerableLimit
extends SingleRel
implements EnumerableRel {
    public final @Nullable RexNode offset;
    public final @Nullable RexNode fetch;

    public EnumerableLimit(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, @Nullable RexNode offset, @Nullable RexNode fetch) {
        super(cluster, traitSet, input);
        this.offset = offset;
        this.fetch = fetch;
        assert (this.getConvention() instanceof EnumerableConvention);
        assert (this.getConvention() == input.getConvention());
    }

    public static EnumerableLimit create(RelNode input, @Nullable RexNode offset, @Nullable RexNode fetch) {
        RelOptCluster cluster = input.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> RelMdCollation.limit(mq, input)).replaceIf(RelDistributionTraitDef.INSTANCE, () -> RelMdDistribution.limit(mq, input));
        return new EnumerableLimit(cluster, traitSet, input, offset, fetch);
    }

    @Override
    public EnumerableLimit copy(RelTraitSet traitSet, List<RelNode> newInputs) {
        return new EnumerableLimit(this.getCluster(), traitSet, EnumerableLimit.sole(newInputs), this.offset, this.fetch);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("offset", this.offset, this.offset != null).itemIf("fetch", this.fetch, this.fetch != null);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInput();
        EnumerableRel.Result result2 = implementor.visitChild(this, 0, child, pref);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), result2.format);
        Expression v = builder.append("child", result2.block);
        if (this.offset != null) {
            v = builder.append("offset", Expressions.call(v, BuiltInMethod.SKIP.method, EnumerableLimit.getExpression(this.offset)));
        }
        if (this.fetch != null) {
            v = builder.append("fetch", Expressions.call(v, BuiltInMethod.TAKE.method, EnumerableLimit.getExpression(this.fetch)));
        }
        builder.add(Expressions.return_(null, v));
        return implementor.result(physType, builder.toBlock());
    }

    static Expression getExpression(RexNode rexNode) {
        if (rexNode instanceof RexDynamicParam) {
            RexDynamicParam param = (RexDynamicParam)rexNode;
            return Expressions.convert_(Expressions.call((Expression)DataContext.ROOT, BuiltInMethod.DATA_CONTEXT_GET.method, Expressions.constant("?" + param.getIndex())), Integer.class);
        }
        return Expressions.constant(RexLiteral.intValue(rexNode));
    }
}

