/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.uzaygezen.core.Content;
import com.google.uzaygezen.core.FilterCombiner;
import com.google.uzaygezen.core.FilteredIndexRange;
import com.google.uzaygezen.core.SelectiveFilter;
import com.google.uzaygezen.core.ranges.Range;
import shaded.com.google.common.base.Preconditions;

public class PlainFilterCombiner<F, T extends Comparable<T>, V extends Content<V>, R extends Range<T, V>>
implements FilterCombiner<F, V, R> {
    private final F fixedFilter;

    public PlainFilterCombiner(F filter) {
        this.fixedFilter = filter;
    }

    @Override
    public SelectiveFilter<F> combine(FilteredIndexRange<F, R> firstFilteredRange, FilteredIndexRange<F, R> secondFilteredRange, V gapEstimate) {
        int gapSignum;
        int cmp = ((Comparable)((Range)firstFilteredRange.getIndexRange()).getEnd()).compareTo(((Range)secondFilteredRange.getIndexRange()).getStart());
        Preconditions.checkArgument(cmp < 0 & (gapSignum = gapEstimate.isZero() ? 0 : 1) >= 0 || cmp == 0 & gapSignum == 0);
        return SelectiveFilter.of(this.fixedFilter, !gapEstimate.isZero() || firstFilteredRange.isPotentialOverSelectivity() || secondFilteredRange.isPotentialOverSelectivity());
    }
}

