/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.elasticmapreduce.model.Studio;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class StudioMarshaller {
    private static final MarshallingInfo<String> STUDIOID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StudioId").build();
    private static final MarshallingInfo<String> STUDIOARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StudioArn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> AUTHMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthMode").build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcId").build();
    private static final MarshallingInfo<List> SUBNETIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetIds").build();
    private static final MarshallingInfo<String> SERVICEROLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRole").build();
    private static final MarshallingInfo<String> USERROLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserRole").build();
    private static final MarshallingInfo<String> WORKSPACESECURITYGROUPID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkspaceSecurityGroupId").build();
    private static final MarshallingInfo<String> ENGINESECURITYGROUPID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineSecurityGroupId").build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Url").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> DEFAULTS3LOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultS3Location").build();
    private static final MarshallingInfo<String> IDPAUTHURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdpAuthUrl").build();
    private static final MarshallingInfo<String> IDPRELAYSTATEPARAMETERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdpRelayStateParameterName").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final MarshallingInfo<String> IDCINSTANCEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdcInstanceArn").build();
    private static final MarshallingInfo<Boolean> TRUSTEDIDENTITYPROPAGATIONENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrustedIdentityPropagationEnabled").build();
    private static final MarshallingInfo<String> IDCUSERASSIGNMENT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdcUserAssignment").build();
    private static final MarshallingInfo<String> ENCRYPTIONKEYARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionKeyArn").build();
    private static final StudioMarshaller instance = new StudioMarshaller();

    public static StudioMarshaller getInstance() {
        return instance;
    }

    public void marshall(Studio studio, ProtocolMarshaller protocolMarshaller) {
        if (studio == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(studio.getStudioId(), STUDIOID_BINDING);
            protocolMarshaller.marshall(studio.getStudioArn(), STUDIOARN_BINDING);
            protocolMarshaller.marshall(studio.getName(), NAME_BINDING);
            protocolMarshaller.marshall(studio.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(studio.getAuthMode(), AUTHMODE_BINDING);
            protocolMarshaller.marshall(studio.getVpcId(), VPCID_BINDING);
            protocolMarshaller.marshall(studio.getSubnetIds(), SUBNETIDS_BINDING);
            protocolMarshaller.marshall(studio.getServiceRole(), SERVICEROLE_BINDING);
            protocolMarshaller.marshall(studio.getUserRole(), USERROLE_BINDING);
            protocolMarshaller.marshall(studio.getWorkspaceSecurityGroupId(), WORKSPACESECURITYGROUPID_BINDING);
            protocolMarshaller.marshall(studio.getEngineSecurityGroupId(), ENGINESECURITYGROUPID_BINDING);
            protocolMarshaller.marshall(studio.getUrl(), URL_BINDING);
            protocolMarshaller.marshall(studio.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(studio.getDefaultS3Location(), DEFAULTS3LOCATION_BINDING);
            protocolMarshaller.marshall(studio.getIdpAuthUrl(), IDPAUTHURL_BINDING);
            protocolMarshaller.marshall(studio.getIdpRelayStateParameterName(), IDPRELAYSTATEPARAMETERNAME_BINDING);
            protocolMarshaller.marshall(studio.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall(studio.getIdcInstanceArn(), IDCINSTANCEARN_BINDING);
            protocolMarshaller.marshall(studio.getTrustedIdentityPropagationEnabled(), TRUSTEDIDENTITYPROPAGATIONENABLED_BINDING);
            protocolMarshaller.marshall(studio.getIdcUserAssignment(), IDCUSERASSIGNMENT_BINDING);
            protocolMarshaller.marshall(studio.getEncryptionKeyArn(), ENCRYPTIONKEYARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

