/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elasticmapreduce.model.ScalingAction;

@SdkInternalApi
public class ScalingActionMarshaller {
    private static final MarshallingInfo<String> MARKET_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Market").build();
    private static final MarshallingInfo<StructuredPojo> SIMPLESCALINGPOLICYCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SimpleScalingPolicyConfiguration").build();
    private static final ScalingActionMarshaller instance = new ScalingActionMarshaller();

    public static ScalingActionMarshaller getInstance() {
        return instance;
    }

    public void marshall(ScalingAction scalingAction, ProtocolMarshaller protocolMarshaller) {
        if (scalingAction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(scalingAction.getMarket(), MARKET_BINDING);
            protocolMarshaller.marshall(scalingAction.getSimpleScalingPolicyConfiguration(), SIMPLESCALINGPOLICYCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

