/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.commons.notifications.action.NotificationsActions;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.indices.SystemIndexDescriptor;
import org.opensearch.notifications.CoreProvider;
import org.opensearch.notifications.action.CreateNotificationConfigAction;
import org.opensearch.notifications.action.DeleteNotificationConfigAction;
import org.opensearch.notifications.action.GetChannelListAction;
import org.opensearch.notifications.action.GetNotificationConfigAction;
import org.opensearch.notifications.action.GetPluginFeaturesAction;
import org.opensearch.notifications.action.PublishNotificationAction;
import org.opensearch.notifications.action.SendNotificationAction;
import org.opensearch.notifications.action.SendTestNotificationAction;
import org.opensearch.notifications.action.UpdateNotificationConfigAction;
import org.opensearch.notifications.index.ConfigIndexingActions;
import org.opensearch.notifications.index.NotificationConfigIndex;
import org.opensearch.notifications.resthandler.NotificationChannelListRestHandler;
import org.opensearch.notifications.resthandler.NotificationConfigRestHandler;
import org.opensearch.notifications.resthandler.NotificationFeaturesRestHandler;
import org.opensearch.notifications.resthandler.PluginBaseHandler;
import org.opensearch.notifications.resthandler.SendTestMessageRestHandler;
import org.opensearch.notifications.security.UserAccessManager;
import org.opensearch.notifications.send.SendMessageActionHelper;
import org.opensearch.notifications.settings.PluginSettings;
import org.opensearch.notifications.spi.NotificationCore;
import org.opensearch.notifications.spi.NotificationCoreExtension;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SystemIndexPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ?2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001?B\u0005\u00a2\u0006\u0002\u0010\u0005Jl\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J\u001e\u0010$\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020'\u0012\u0006\b\u0001\u0012\u00020(0&0%H\u0016JL\u0010)\u001a\b\u0012\u0004\u0012\u00020*0%2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u0010\u001f\u001a\u00020 2\f\u00105\u001a\b\u0012\u0004\u0012\u0002060\"H\u0016J\u0012\u00107\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003080%H\u0016J\u0018\u00109\u001a\b\u0012\u0004\u0012\u00020:0\r2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006@"}, d2={"Lorg/opensearch/notifications/NotificationPlugin;", "Lorg/opensearch/plugins/ActionPlugin;", "Lorg/opensearch/plugins/Plugin;", "Lorg/opensearch/notifications/spi/NotificationCoreExtension;", "Lorg/opensearch/plugins/SystemIndexPlugin;", "()V", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "setClusterService", "(Lorg/opensearch/cluster/service/ClusterService;)V", "createComponents", "", "", "client", "Lorg/opensearch/client/Client;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "resourceWatcherService", "Lorg/opensearch/watcher/ResourceWatcherService;", "scriptService", "Lorg/opensearch/script/ScriptService;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "environment", "Lorg/opensearch/env/Environment;", "nodeEnvironment", "Lorg/opensearch/env/NodeEnvironment;", "namedWriteableRegistry", "Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "repositoriesServiceSupplier", "Ljava/util/function/Supplier;", "Lorg/opensearch/repositories/RepositoriesService;", "getActions", "", "Lorg/opensearch/plugins/ActionPlugin$ActionHandler;", "Lorg/opensearch/action/ActionRequest;", "Lorg/opensearch/core/action/ActionResponse;", "getRestHandlers", "Lorg/opensearch/rest/RestHandler;", "settings", "Lorg/opensearch/common/settings/Settings;", "restController", "Lorg/opensearch/rest/RestController;", "clusterSettings", "Lorg/opensearch/common/settings/ClusterSettings;", "indexScopedSettings", "Lorg/opensearch/common/settings/IndexScopedSettings;", "settingsFilter", "Lorg/opensearch/common/settings/SettingsFilter;", "nodesInCluster", "Lorg/opensearch/cluster/node/DiscoveryNodes;", "getSettings", "Lorg/opensearch/common/settings/Setting;", "getSystemIndexDescriptors", "Lorg/opensearch/indices/SystemIndexDescriptor;", "setNotificationCore", "", "core", "Lorg/opensearch/notifications/spi/NotificationCore;", "Companion", "opensearch-notifications"})
public final class NotificationPlugin
extends Plugin
implements ActionPlugin,
NotificationCoreExtension,
SystemIndexPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public ClusterService clusterService;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(NotificationPlugin.class);
    @NotNull
    public static final String PLUGIN_NAME = "opensearch-notifications";
    @NotNull
    public static final String LOG_PREFIX = "notifications";
    @NotNull
    public static final String PLUGIN_BASE_URI = "/_plugins/_notifications";
    @NotNull
    public static final String TEXT_QUERY_TAG = "text_query";

    @NotNull
    public final ClusterService getClusterService() {
        ClusterService clusterService = this.clusterService;
        if (clusterService != null) {
            return clusterService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
        return null;
    }

    public final void setClusterService(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"<set-?>");
        this.clusterService = clusterService;
    }

    @NotNull
    public List<Setting<?>> getSettings() {
        NotificationPlugin.Companion.getLog().debug("notifications:getSettings");
        return PluginSettings.INSTANCE.getAllSettings();
    }

    @NotNull
    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(@Nullable Settings settings) {
        return CollectionsKt.listOf((Object)new SystemIndexDescriptor(".opensearch-notifications-config", "System index for storing notification channels related configurations."));
    }

    @NotNull
    public Collection<Object> createComponents(@NotNull Client client, @NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull ResourceWatcherService resourceWatcherService, @NotNull ScriptService scriptService, @NotNull NamedXContentRegistry xContentRegistry, @NotNull Environment environment, @NotNull NodeEnvironment nodeEnvironment, @NotNull NamedWriteableRegistry namedWriteableRegistry, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull Supplier<RepositoriesService> repositoriesServiceSupplier) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)resourceWatcherService, (String)"resourceWatcherService");
        Intrinsics.checkNotNullParameter((Object)scriptService, (String)"scriptService");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)nodeEnvironment, (String)"nodeEnvironment");
        Intrinsics.checkNotNullParameter((Object)namedWriteableRegistry, (String)"namedWriteableRegistry");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkNotNullParameter(repositoriesServiceSupplier, (String)"repositoriesServiceSupplier");
        NotificationPlugin.Companion.getLog().debug("notifications:createComponents");
        this.setClusterService(clusterService);
        PluginSettings.INSTANCE.addSettingsUpdateConsumer(clusterService);
        NotificationConfigIndex.INSTANCE.initialize(client, clusterService);
        ConfigIndexingActions.INSTANCE.initialize(NotificationConfigIndex.INSTANCE, UserAccessManager.INSTANCE);
        SendMessageActionHelper.INSTANCE.initialize(NotificationConfigIndex.INSTANCE, UserAccessManager.INSTANCE);
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        NotificationPlugin.Companion.getLog().debug("notifications:getActions");
        Object[] objectArray = new ActionPlugin.ActionHandler[]{new ActionPlugin.ActionHandler(SendTestNotificationAction.Companion.getACTION_TYPE$opensearch_notifications(), SendTestNotificationAction.class, new Class[0]), new ActionPlugin.ActionHandler(NotificationsActions.INSTANCE.getCREATE_NOTIFICATION_CONFIG_ACTION_TYPE(), CreateNotificationConfigAction.class, new Class[0]), new ActionPlugin.ActionHandler(NotificationsActions.INSTANCE.getUPDATE_NOTIFICATION_CONFIG_ACTION_TYPE(), UpdateNotificationConfigAction.class, new Class[0]), new ActionPlugin.ActionHandler(NotificationsActions.INSTANCE.getDELETE_NOTIFICATION_CONFIG_ACTION_TYPE(), DeleteNotificationConfigAction.class, new Class[0]), new ActionPlugin.ActionHandler(NotificationsActions.INSTANCE.getGET_NOTIFICATION_CONFIG_ACTION_TYPE(), GetNotificationConfigAction.class, new Class[0]), new ActionPlugin.ActionHandler(NotificationsActions.INSTANCE.getGET_CHANNEL_LIST_ACTION_TYPE(), GetChannelListAction.class, new Class[0]), new ActionPlugin.ActionHandler(NotificationsActions.INSTANCE.getGET_PLUGIN_FEATURES_ACTION_TYPE(), GetPluginFeaturesAction.class, new Class[0]), new ActionPlugin.ActionHandler(NotificationsActions.INSTANCE.getSEND_NOTIFICATION_ACTION_TYPE(), SendNotificationAction.class, new Class[0]), new ActionPlugin.ActionHandler(NotificationsActions.INSTANCE.getLEGACY_PUBLISH_NOTIFICATION_ACTION_TYPE(), PublishNotificationAction.class, new Class[0])};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<RestHandler> getRestHandlers(@NotNull Settings settings, @NotNull RestController restController, @NotNull ClusterSettings clusterSettings, @NotNull IndexScopedSettings indexScopedSettings, @NotNull SettingsFilter settingsFilter, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull Supplier<DiscoveryNodes> nodesInCluster) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)restController, (String)"restController");
        Intrinsics.checkNotNullParameter((Object)clusterSettings, (String)"clusterSettings");
        Intrinsics.checkNotNullParameter((Object)indexScopedSettings, (String)"indexScopedSettings");
        Intrinsics.checkNotNullParameter((Object)settingsFilter, (String)"settingsFilter");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkNotNullParameter(nodesInCluster, (String)"nodesInCluster");
        NotificationPlugin.Companion.getLog().debug("notifications:getRestHandlers");
        PluginBaseHandler[] pluginBaseHandlerArray = new PluginBaseHandler[]{new NotificationConfigRestHandler(), new NotificationFeaturesRestHandler(), new NotificationChannelListRestHandler(), new SendTestMessageRestHandler()};
        return CollectionsKt.listOf((Object[])pluginBaseHandlerArray);
    }

    public void setNotificationCore(@NotNull NotificationCore core) {
        Intrinsics.checkNotNullParameter((Object)core, (String)"core");
        NotificationPlugin.Companion.getLog().debug("notifications:setNotificationCore");
        CoreProvider.INSTANCE.initialize(core);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/notifications/NotificationPlugin$Companion;", "", "()V", "LOG_PREFIX", "", "PLUGIN_BASE_URI", "PLUGIN_NAME", "TEXT_QUERY_TAG", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "opensearch-notifications"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

