/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar.extractors;

import com.oracle.labs.mlrg.olcut.config.Config;
import java.util.Optional;
import java.util.logging.Logger;
import org.tribuo.data.columnar.ColumnarIterator;
import org.tribuo.data.columnar.FieldExtractor;

public abstract class SimpleFieldExtractor<T>
implements FieldExtractor<T> {
    private static final Logger logger = Logger.getLogger(SimpleFieldExtractor.class.getName());
    @Config(mandatory=true, description="The field name to read.")
    protected String fieldName;
    @Config(description="The metadata key to emit, defaults to field name if unpopulated")
    protected String metadataName;

    protected SimpleFieldExtractor(String fieldName) {
        this(fieldName, fieldName);
    }

    protected SimpleFieldExtractor(String fieldName, String metadataName) {
        this.fieldName = fieldName;
        this.metadataName = metadataName;
    }

    protected SimpleFieldExtractor() {
    }

    public void postConfig() {
        if (this.metadataName == null || this.metadataName.isEmpty()) {
            this.metadataName = this.fieldName;
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getMetadataName() {
        return this.metadataName;
    }

    protected abstract Optional<T> extractField(String var1);

    @Override
    public Optional<T> extract(ColumnarIterator.Row row) {
        if (row.getRowData().containsKey(this.getFieldName())) {
            return this.extractField(row.getRowData().get(this.getFieldName()));
        }
        logger.warning("Row was missing expected field " + this.getFieldName());
        return Optional.empty();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fieldName=" + this.fieldName + ", metadataName=" + this.metadataName + ")";
    }
}

