/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN990Codec;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.opensearch.knn.quantization.enums.ScalarQuantizationType;
import org.opensearch.knn.quantization.models.quantizationParams.ScalarQuantizationParams;
import org.opensearch.knn.quantization.models.quantizationState.MultiBitScalarQuantizationState;
import org.opensearch.knn.quantization.models.quantizationState.OneBitScalarQuantizationState;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationState;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationStateReadConfig;

public final class KNN990QuantizationStateReader {
    @Generated
    private static final Logger log = LogManager.getLogger(KNN990QuantizationStateReader.class);

    public static QuantizationState read(QuantizationStateReadConfig readConfig) throws IOException {
        SegmentReadState segmentReadState = readConfig.getSegmentReadState();
        String field = readConfig.getField();
        String quantizationStateFileName = KNN990QuantizationStateReader.getQuantizationStateFileName(segmentReadState);
        int fieldNumber = segmentReadState.fieldInfos.fieldInfo(field).getFieldNumber();
        try (IndexInput input = segmentReadState.directory.openInput(quantizationStateFileName, IOContext.READ);){
            CodecUtil.retrieveChecksum((IndexInput)input);
            int numFields = KNN990QuantizationStateReader.getNumFields(input);
            long position = -1L;
            int length = 0;
            for (int i = 0; i < numFields; ++i) {
                int tempFieldNumber = input.readInt();
                int tempLength = input.readInt();
                long tempPosition = input.readVLong();
                if (tempFieldNumber != fieldNumber) continue;
                position = tempPosition;
                length = tempLength;
                break;
            }
            if (position == -1L || length == 0) {
                throw new IllegalArgumentException(String.format("Field %s not found", field));
            }
            byte[] stateBytes = KNN990QuantizationStateReader.readStateBytes(input, position, length);
            ScalarQuantizationType scalarQuantizationType = ((ScalarQuantizationParams)readConfig.getQuantizationParams()).getSqType();
            switch (scalarQuantizationType) {
                case ONE_BIT: {
                    OneBitScalarQuantizationState oneBitScalarQuantizationState = OneBitScalarQuantizationState.fromByteArray(stateBytes);
                    return oneBitScalarQuantizationState;
                }
                case TWO_BIT: 
                case FOUR_BIT: {
                    MultiBitScalarQuantizationState multiBitScalarQuantizationState = MultiBitScalarQuantizationState.fromByteArray(stateBytes);
                    return multiBitScalarQuantizationState;
                }
            }
            throw new IllegalArgumentException(String.format("Unexpected scalar quantization type: %s", new Object[]{scalarQuantizationType}));
        }
    }

    @VisibleForTesting
    static int getNumFields(IndexInput input) throws IOException {
        long footerStart = input.length() - (long)CodecUtil.footerLength();
        long markerAndIndexPosition = footerStart - 4L - 8L;
        input.seek(markerAndIndexPosition);
        long indexStartPosition = input.readLong();
        input.seek(indexStartPosition);
        return input.readInt();
    }

    @VisibleForTesting
    static byte[] readStateBytes(IndexInput input, long position, int length) throws IOException {
        input.seek(position);
        byte[] stateBytes = new byte[length];
        input.readBytes(stateBytes, 0, length);
        return stateBytes;
    }

    @VisibleForTesting
    static String getQuantizationStateFileName(SegmentReadState state) {
        return IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"osknnqstate");
    }
}

