/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SummaryStatus {
    OK("ok"),
    IMPAIRED("impaired"),
    INSUFFICIENT_DATA("insufficient-data"),
    NOT_APPLICABLE("not-applicable"),
    INITIALIZING("initializing"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SummaryStatus> VALUE_MAP;
    private final String value;

    private SummaryStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SummaryStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SummaryStatus> knownValues() {
        EnumSet<SummaryStatus> knownValues = EnumSet.allOf(SummaryStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SummaryStatus.class, SummaryStatus::toString);
    }
}

