/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tools.cli.upgrade;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.cli.Terminal;
import org.opensearch.common.collect.Tuple;
import org.opensearch.tools.cli.upgrade.TaskInput;
import org.opensearch.tools.cli.upgrade.UpgradeTask;

class ValidateInputTask
implements UpgradeTask {
    ValidateInputTask() {
    }

    @Override
    public void accept(Tuple<TaskInput, Terminal> input) {
        TaskInput taskInput = (TaskInput)input.v1();
        Terminal terminal = (Terminal)input.v2();
        terminal.println("Verifying the details ...");
        if (taskInput.getVersion().isPresent()) {
            Version version = taskInput.getVersion().get();
            if (!version.equals((Object)LegacyESVersion.fromId((int)7100299))) {
                throw new RuntimeException(String.format(Locale.getDefault(), "The installed version %s of elasticsearch is not supported.", version));
            }
        } else {
            terminal.println("Unable to detect installed elasticsearch version.");
            this.confirmToProceed(terminal);
        }
        if (taskInput.getOpenSearchConfig().getParent().equals(taskInput.getOpenSearchBin().getParent())) {
            terminal.println("OpenSearch config directory is set inside the installation directory. It is recommended to use an external config directory and set the environment variable OPENSEARCH_PATH_CONF to it.");
            this.confirmToProceed(terminal);
        }
        Map<String, String> fieldsMap = this.getSummaryFieldsMap(taskInput);
        String format = " %-25s | %s";
        terminal.println("+----------------------- SUMMARY -----------------------+");
        for (Map.Entry<String, String> entry : fieldsMap.entrySet()) {
            terminal.println(String.format(Locale.getDefault(), " %-25s | %s", entry.getKey(), entry.getValue()));
        }
        terminal.println("+-------------------------------------------------------+");
        terminal.println("Please verify if everything above looks good.");
        this.confirmToProceed(terminal);
    }

    private void confirmToProceed(Terminal terminal) {
        terminal.println(System.lineSeparator());
        if (!terminal.promptYesNo("Do you want to proceed?", false)) {
            throw new RuntimeException("Upgrade cancelled by user.");
        }
    }

    Map<String, String> getSummaryFieldsMap(TaskInput taskInput) {
        String version = taskInput.getVersion().isPresent() ? taskInput.getVersion().get().toString() : "unknown";
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("Cluster", taskInput.getCluster());
        fields.put("Node", taskInput.getNode());
        fields.put("Endpoint", taskInput.getBaseUrl());
        fields.put("Elasticsearch Version", version);
        fields.put("Elasticsearch Config", taskInput.getEsConfig().toString());
        fields.put("Elasticsearch Plugins", taskInput.getPlugins() == null ? "[]" : taskInput.getPlugins().toString());
        fields.put("OpenSearch Config", taskInput.getOpenSearchConfig().toString());
        return fields;
    }
}

