/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;

public final class Randomness {
    private static final Method currentMethod;
    private static final Method getRandomMethod;

    private Randomness() {
    }

    public static Random get(Settings settings, Setting<Long> setting) {
        if (setting.exists(settings)) {
            return new Random(setting.get(settings));
        }
        return Randomness.get();
    }

    public static Random get() {
        if (currentMethod != null && getRandomMethod != null) {
            try {
                Object randomizedContext = currentMethod.invoke(null, new Object[0]);
                return (Random)getRandomMethod.invoke(randomizedContext, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("running tests but failed to invoke RandomizedContext#getRandom", e);
            }
        }
        return Randomness.getWithoutSeed();
    }

    public static SecureRandom createSecure() {
        try {
            Class<?> registrarClass = Class.forName("org.bouncycastle.crypto.CryptoServicesRegistrar");
            Method isApprovedOnlyMethod = registrarClass.getMethod("isInApprovedOnlyMode", new Class[0]);
            Boolean approvedOnly = (Boolean)isApprovedOnlyMethod.invoke(null, new Object[0]);
            if (approvedOnly.booleanValue()) {
                boolean isPredictionResistant = true;
                SecureRandom entropySource = SecureRandom.getInstance("DEFAULT", "BCFIPS");
                Class<?> basicEntropyProviderClass = Class.forName("org.bouncycastle.crypto.util.BasicEntropySourceProvider");
                Constructor<?> entropyConstructor = basicEntropyProviderClass.getConstructor(SecureRandom.class, Boolean.TYPE);
                Object entropyProvider = entropyConstructor.newInstance(entropySource, isPredictionResistant);
                Class<?> fipsDrbgClass = Class.forName("org.bouncycastle.crypto.fips.FipsDRBG");
                Field sha512HmacField = fipsDrbgClass.getField("SHA512_HMAC");
                Object sha512Hmac = sha512HmacField.get(null);
                Class<?> entropyProviderClass = Class.forName("org.bouncycastle.crypto.EntropySourceProvider");
                Method fromEntropySourceMethod = sha512Hmac.getClass().getMethod("fromEntropySource", entropyProviderClass);
                Object builder = fromEntropySourceMethod.invoke(sha512Hmac, entropyProvider);
                Method buildMethod = builder.getClass().getMethod("build", byte[].class, Boolean.TYPE);
                Object drbgInstance = buildMethod.invoke(builder, null, isPredictionResistant);
                return (SecureRandom)drbgInstance;
            }
            return SecureRandom.getInstanceStrong();
        }
        catch (ReflectiveOperationException | GeneralSecurityException e) {
            try {
                return SecureRandom.getInstanceStrong();
            }
            catch (NoSuchAlgorithmException ex) {
                throw new SecurityException("Failed to instantiate SecureRandom: " + e.getMessage(), e);
            }
        }
    }

    @SuppressForbidden(reason="ThreadLocalRandom is okay when not running tests")
    private static Random getWithoutSeed() {
        assert (currentMethod == null && getRandomMethod == null) : "running under tests but tried to create non-reproducible random";
        return ThreadLocalRandom.current();
    }

    public static void shuffle(List<?> list) {
        Collections.shuffle(list, Randomness.get());
    }

    static {
        Method maybeGetRandomMethod;
        Method maybeCurrentMethod;
        try {
            Class<?> clazz = Class.forName("com.carrotsearch.randomizedtesting.RandomizedContext");
            maybeCurrentMethod = clazz.getMethod("current", new Class[0]);
            maybeGetRandomMethod = clazz.getMethod("getRandom", new Class[0]);
        }
        catch (Exception e) {
            maybeCurrentMethod = null;
            maybeGetRandomMethod = null;
        }
        currentMethod = maybeCurrentMethod;
        getRandomMethod = maybeGetRandomMethod;
    }
}

