/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Arrays;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.EncodeForUri;
import net.sf.saxon.functions.ScalarSystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntIterator;

public class IriToUri
extends ScalarSystemFunction {
    public static boolean[] allowedASCII = new boolean[128];

    @Override
    public AtomicValue evaluate(Item arg, XPathContext context) throws XPathException {
        return new StringValue(IriToUri.iriToUri(arg.getUnicodeStringValue()));
    }

    @Override
    public Sequence resultWhenEmpty() {
        return StringValue.EMPTY_STRING;
    }

    public static UnicodeString iriToUri(UnicodeString s) {
        if (IriToUri.allAllowedAscii(s.codePoints())) {
            return s;
        }
        UnicodeBuilder sb = new UnicodeBuilder(s.length32() + 20);
        IntIterator iter = s.codePoints();
        while (iter.hasNext()) {
            int c = iter.next();
            if (c >= 127 || !allowedASCII[c]) {
                EncodeForUri.escapeChar(c, sb);
                continue;
            }
            sb.append(c);
        }
        return sb.toUnicodeString();
    }

    private static boolean allAllowedAscii(IntIterator codePoints) {
        while (codePoints.hasNext()) {
            int c = codePoints.next();
            if (c < 127 && allowedASCII[c]) continue;
            return false;
        }
        return true;
    }

    static {
        Arrays.fill(allowedASCII, 0, 32, false);
        Arrays.fill(allowedASCII, 33, 127, true);
        IriToUri.allowedASCII[34] = false;
        IriToUri.allowedASCII[60] = false;
        IriToUri.allowedASCII[62] = false;
        IriToUri.allowedASCII[92] = false;
        IriToUri.allowedASCII[94] = false;
        IriToUri.allowedASCII[96] = false;
        IriToUri.allowedASCII[123] = false;
        IriToUri.allowedASCII[124] = false;
        IriToUri.allowedASCII[125] = false;
    }
}

