"use strict";
/*
 * Wire
 * Copyright (C) 2019 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.useTimeout = void 0;
const react_1 = require("react");
const useTimeout = (onTimeoutStop, duration) => {
    const timerRef = (0, react_1.useRef)(null);
    const removeTimeout = () => {
        if (timerRef.current) {
            window.clearTimeout(timerRef.current);
            timerRef.current = null;
        }
    };
    const start = () => {
        removeTimeout();
        timerRef.current = window.setTimeout(onStop, duration);
    };
    const onStop = () => {
        removeTimeout();
        onTimeoutStop();
    };
    (0, react_1.useEffect)(() => {
        return () => {
            removeTimeout();
        };
    }, [duration, onTimeoutStop]);
    return { removeTimeout, startTimeout: start };
};
exports.useTimeout = useTimeout;
