"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pill = exports.filterPillProps = exports.pillStyle = exports.PILL_TYPE = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const react_1 = require("@emotion/react");
const Identity_1 = require("../Identity");
const motions_1 = require("../Identity/motions");
const util_1 = require("../util");
var PILL_TYPE;
(function (PILL_TYPE) {
    PILL_TYPE["error"] = "ERROR";
    PILL_TYPE["success"] = "SUCCESS";
    PILL_TYPE["warning"] = "WARNING";
})(PILL_TYPE = exports.PILL_TYPE || (exports.PILL_TYPE = {}));
const pillStyle = (theme, { active = false, type = null }) => {
    const backgroundColors = {
        [PILL_TYPE.error]: Identity_1.COLOR.RED_OPAQUE_32,
        [PILL_TYPE.success]: Identity_1.COLOR.GREEN_OPAQUE_32,
        [PILL_TYPE.warning]: Identity_1.COLOR.YELLOW_OPAQUE_32,
    };
    const backgroundColor = active ? '#eee' : type ? backgroundColors[type] : 'transparent';
    const pillAnimation = (0, react_1.keyframes) `
    0% {
      background-color: transparent;
    }
    100% {
      background-color: ${backgroundColor};
    }
`;
    return {
        '&:first-of-type': {
            marginLeft: 0,
        },
        '&:last-of-type': {
            marginRight: 0,
        },
        animation: `${pillAnimation} ${motions_1.DURATION.DEFAULT}ms ${motions_1.EASE.QUART}`,
        backgroundColor,
        borderRadius: '160px',
        color: active ? Identity_1.COLOR.TEXT : theme.general.color,
        cursor: active ? 'default' : undefined,
        display: 'inline-block',
        fontSize: theme.fontSizes.small,
        lineHeight: '1rem',
        margin: type ? '12px 0 0 0' : '0 8px',
        minHeight: '32px',
        padding: '8px 24px',
        textAlign: 'center',
        textDecoration: 'none',
    };
};
exports.pillStyle = pillStyle;
const filterPillProps = (props) => (0, util_1.filterProps)(props, ['active']);
exports.filterPillProps = filterPillProps;
const Pill = (props) => ((0, jsx_runtime_1.jsx)("span", Object.assign({ css: (theme) => (0, exports.pillStyle)(theme, props), "data-uie-name": "element-pill", "data-uie-status": props.type }, (0, exports.filterPillProps)(props))));
exports.Pill = Pill;
