//============================================================================
//  The contents of this file are covered by the Viskores license. See
//  LICENSE.txt for details.
//
//  By contributing to this file, all contributors agree to the Developer
//  Certificate of Origin Version 1.1 (DCO 1.1) as stated in DCO.txt.
//============================================================================

//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//============================================================================
//  Copyright (c) 2016, Los Alamos National Security, LLC
//  All rights reserved.
//
//  Copyright 2016. Los Alamos National Security, LLC.
//  This software was produced under U.S. Government contract DE-AC52-06NA25396
//  for Los Alamos National Laboratory (LANL), which is operated by
//  Los Alamos National Security, LLC for the U.S. Department of Energy.
//  The U.S. Government has rights to use, reproduce, and distribute this
//  software.  NEITHER THE GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC
//  MAKES ANY WARRANTY, EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE
//  USE OF THIS SOFTWARE.  If software is modified to produce derivative works,
//  such modified software should be clearly marked, so as not to confuse it
//  with the version available from LANL.
//
//  Additionally, redistribution and use in source and binary forms, with or
//  without modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//  3. Neither the name of Los Alamos National Security, LLC, Los Alamos
//     National Laboratory, LANL, the U.S. Government, nor the names of its
//     contributors may be used to endorse or promote products derived from
//     this software without specific prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY LOS ALAMOS NATIONAL SECURITY, LLC AND
//  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
//  BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
//  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL LOS ALAMOS
//  NATIONAL SECURITY, LLC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
//  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
//  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
//  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
//  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
//  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
//  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//============================================================================

//  This code is based on the algorithm presented in the paper:
//  “Parallel Peak Pruning for Scalable SMP Contour Tree Computation.”
//  Hamish Carr, Gunther Weber, Christopher Sewell, and James Ahrens.
//  Proceedings of the IEEE Symposium on Large Data Analysis and Visualization
//  (LDAV), October 2016, Baltimore, Maryland.

#ifndef viskores_worklet_contourtree_link_component_case_table_3d_h
#define viskores_worklet_contourtree_link_component_case_table_3d_h

#include <viskores/Types.h>
#include <viskores/filter/scalar_topology/worklet/contourtree/Mesh3D_DEM_Triangulation_Macros.h>

namespace viskores
{
namespace worklet
{
namespace contourtree
{

const viskores::IdComponent neighbourOffsets3D[42] = { -1, -1, -1, 0,  -1, 0, -1, -1, 0,  -1, 0,
                                                       0,  -1, 0,  -1, 0,  0, -1, 0,  -1, -1, 0,
                                                       0,  1,  0,  1,  0,  0, 1,  1,  1,  0,  0,
                                                       1,  0,  1,  1,  1,  0, 1,  1,  1 };

const viskores::UInt16 linkComponentCaseTable3D[16384] = {
  0,    1,    2,    2,    4,    4,    4,    4,    8,    8,    10,   8,    8,    8,    8,    8,
  16,   16,   18,   16,   20,   16,   20,   16,   16,   16,   18,   16,   16,   16,   16,   16,
  32,   32,   34,   32,   36,   32,   36,   32,   40,   32,   42,   32,   40,   32,   40,   32,
  32,   32,   34,   32,   36,   32,   36,   32,   32,   32,   34,   32,   32,   32,   32,   32,
  64,   64,   64,   64,   68,   64,   64,   64,   72,   64,   72,   64,   72,   64,   64,   64,
  80,   64,   80,   64,   84,   64,   80,   64,   80,   64,   80,   64,   80,   64,   64,   64,
  64,   64,   64,   64,   68,   64,   64,   64,   72,   64,   72,   64,   72,   64,   64,   64,
  64,   64,   64,   64,   68,   64,   64,   64,   64,   64,   64,   64,   64,   64,   64,   64,
  128,  129,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,
  144,  144,  144,  128,  144,  128,  144,  128,  128,  128,  128,  128,  128,  128,  128,  128,
  160,  160,  160,  128,  160,  128,  160,  128,  160,  128,  160,  128,  160,  128,  160,  128,
  160,  160,  160,  128,  160,  128,  160,  128,  128,  128,  128,  128,  128,  128,  128,  128,
  192,  192,  128,  128,  192,  128,  128,  128,  192,  128,  128,  128,  192,  128,  128,  128,
  208,  192,  144,  128,  208,  128,  144,  128,  192,  128,  128,  128,  192,  128,  128,  128,
  192,  192,  128,  128,  192,  128,  128,  128,  192,  128,  128,  128,  192,  128,  128,  128,
  192,  192,  128,  128,  192,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,
  256,  257,  258,  258,  260,  260,  260,  260,  256,  256,  258,  256,  256,  256,  256,  256,
  256,  256,  258,  256,  260,  256,  260,  256,  256,  256,  258,  256,  256,  256,  256,  256,
  256,  256,  258,  256,  260,  256,  260,  256,  256,  256,  258,  256,  256,  256,  256,  256,
  256,  256,  258,  256,  260,  256,  260,  256,  256,  256,  258,  256,  256,  256,  256,  256,
  320,  320,  320,  320,  324,  320,  320,  320,  320,  256,  320,  256,  320,  256,  256,  256,
  320,  256,  320,  256,  324,  256,  320,  256,  320,  256,  320,  256,  320,  256,  256,  256,
  256,  256,  256,  256,  260,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,
  256,  256,  256,  256,  260,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,
  384,  385,  384,  384,  384,  384,  384,  384,  256,  256,  256,  256,  256,  256,  256,  256,
  384,  384,  384,  256,  384,  256,  384,  256,  256,  256,  256,  256,  256,  256,  256,  256,
  384,  384,  384,  256,  384,  256,  384,  256,  256,  256,  256,  256,  256,  256,  256,  256,
  384,  384,  384,  256,  384,  256,  384,  256,  256,  256,  256,  256,  256,  256,  256,  256,
  448,  448,  384,  384,  448,  384,  384,  384,  320,  256,  256,  256,  320,  256,  256,  256,
  448,  384,  384,  256,  448,  256,  384,  256,  320,  256,  256,  256,  320,  256,  256,  256,
  384,  384,  256,  256,  384,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,
  384,  384,  256,  256,  384,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,
  512,  513,  514,  514,  516,  516,  516,  516,  512,  512,  514,  512,  512,  512,  512,  512,
  528,  528,  530,  528,  532,  528,  532,  528,  512,  512,  514,  512,  512,  512,  512,  512,
  544,  544,  546,  544,  548,  544,  548,  544,  544,  512,  546,  512,  544,  512,  544,  512,
  544,  544,  546,  544,  548,  544,  548,  544,  512,  512,  514,  512,  512,  512,  512,  512,
  576,  576,  576,  576,  580,  576,  576,  576,  576,  512,  576,  512,  576,  512,  512,  512,
  592,  576,  592,  576,  596,  576,  592,  576,  576,  512,  576,  512,  576,  512,  512,  512,
  576,  576,  576,  576,  580,  576,  576,  576,  576,  512,  576,  512,  576,  512,  512,  512,
  576,  576,  576,  576,  580,  576,  576,  576,  512,  512,  512,  512,  512,  512,  512,  512,
  512,  513,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  528,  528,  528,  512,  528,  512,  528,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  544,  544,  544,  512,  544,  512,  544,  512,  544,  512,  544,  512,  544,  512,  544,  512,
  544,  544,  544,  512,  544,  512,  544,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  576,  576,  512,  512,  576,  512,  512,  512,  576,  512,  512,  512,  576,  512,  512,  512,
  592,  576,  528,  512,  592,  512,  528,  512,  576,  512,  512,  512,  576,  512,  512,  512,
  576,  576,  512,  512,  576,  512,  512,  512,  576,  512,  512,  512,  576,  512,  512,  512,
  576,  576,  512,  512,  576,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  512,  513,  514,  514,  516,  516,  516,  516,  512,  512,  514,  512,  512,  512,  512,  512,
  512,  512,  514,  512,  516,  512,  516,  512,  512,  512,  514,  512,  512,  512,  512,  512,
  512,  512,  514,  512,  516,  512,  516,  512,  512,  512,  514,  512,  512,  512,  512,  512,
  512,  512,  514,  512,  516,  512,  516,  512,  512,  512,  514,  512,  512,  512,  512,  512,
  576,  576,  576,  576,  580,  576,  576,  576,  576,  512,  576,  512,  576,  512,  512,  512,
  576,  512,  576,  512,  580,  512,  576,  512,  576,  512,  576,  512,  576,  512,  512,  512,
  512,  512,  512,  512,  516,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  512,  512,  512,  512,  516,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  512,  513,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  576,  576,  512,  512,  576,  512,  512,  512,  576,  512,  512,  512,  576,  512,  512,  512,
  576,  512,  512,  512,  576,  512,  512,  512,  576,  512,  512,  512,  576,  512,  512,  512,
  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  1024, 1025, 1024, 1024, 1028, 1028, 1024, 1024, 1032, 1032, 1032, 1024, 1032, 1032, 1024, 1024,
  1040, 1040, 1040, 1024, 1044, 1040, 1040, 1024, 1040, 1040, 1040, 1024, 1040, 1040, 1024, 1024,
  1024, 1024, 1024, 1024, 1028, 1024, 1024, 1024, 1032, 1024, 1032, 1024, 1032, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1028, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1028, 1024, 1024, 1024, 1032, 1024, 1032, 1024, 1032, 1024, 1024, 1024,
  1040, 1024, 1040, 1024, 1044, 1024, 1040, 1024, 1040, 1024, 1040, 1024, 1040, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1028, 1024, 1024, 1024, 1032, 1024, 1032, 1024, 1032, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1028, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1152, 1153, 1024, 1024, 1152, 1152, 1024, 1024, 1152, 1152, 1024, 1024, 1152, 1152, 1024, 1024,
  1168, 1168, 1040, 1024, 1168, 1152, 1040, 1024, 1152, 1152, 1024, 1024, 1152, 1152, 1024, 1024,
  1152, 1152, 1024, 1024, 1152, 1024, 1024, 1024, 1152, 1024, 1024, 1024, 1152, 1024, 1024, 1024,
  1152, 1152, 1024, 1024, 1152, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1152, 1152, 1024, 1024, 1152, 1024, 1024, 1024, 1152, 1024, 1024, 1024, 1152, 1024, 1024, 1024,
  1168, 1152, 1040, 1024, 1168, 1024, 1040, 1024, 1152, 1024, 1024, 1024, 1152, 1024, 1024, 1024,
  1152, 1152, 1024, 1024, 1152, 1024, 1024, 1024, 1152, 1024, 1024, 1024, 1152, 1024, 1024, 1024,
  1152, 1152, 1024, 1024, 1152, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1280, 1281, 1280, 1280, 1284, 1284, 1280, 1280, 1280, 1280, 1280, 1024, 1280, 1280, 1024, 1024,
  1280, 1280, 1280, 1024, 1284, 1280, 1280, 1024, 1280, 1280, 1280, 1024, 1280, 1280, 1024, 1024,
  1024, 1024, 1024, 1024, 1028, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1028, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1280, 1280, 1280, 1280, 1284, 1280, 1280, 1280, 1280, 1024, 1280, 1024, 1280, 1024, 1024, 1024,
  1280, 1024, 1280, 1024, 1284, 1024, 1280, 1024, 1280, 1024, 1280, 1024, 1280, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1028, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1028, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1408, 1409, 1280, 1280, 1408, 1408, 1280, 1280, 1280, 1280, 1024, 1024, 1280, 1280, 1024, 1024,
  1408, 1408, 1280, 1024, 1408, 1280, 1280, 1024, 1280, 1280, 1024, 1024, 1280, 1280, 1024, 1024,
  1152, 1152, 1024, 1024, 1152, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1152, 1152, 1024, 1024, 1152, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1408, 1408, 1280, 1280, 1408, 1280, 1280, 1280, 1280, 1024, 1024, 1024, 1280, 1024, 1024, 1024,
  1408, 1152, 1280, 1024, 1408, 1024, 1280, 1024, 1280, 1024, 1024, 1024, 1280, 1024, 1024, 1024,
  1152, 1152, 1024, 1024, 1152, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1152, 1152, 1024, 1024, 1152, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1536, 1537, 1536, 1536, 1540, 1540, 1536, 1536, 1536, 1536, 1536, 1024, 1536, 1536, 1024, 1024,
  1552, 1552, 1552, 1536, 1556, 1552, 1552, 1536, 1536, 1536, 1536, 1024, 1536, 1536, 1024, 1024,
  1536, 1536, 1536, 1536, 1540, 1536, 1536, 1536, 1536, 1024, 1536, 1024, 1536, 1024, 1024, 1024,
  1536, 1536, 1536, 1536, 1540, 1536, 1536, 1536, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1536, 1536, 1536, 1536, 1540, 1536, 1536, 1536, 1536, 1024, 1536, 1024, 1536, 1024, 1024, 1024,
  1552, 1536, 1552, 1536, 1556, 1536, 1552, 1536, 1536, 1024, 1536, 1024, 1536, 1024, 1024, 1024,
  1536, 1536, 1536, 1536, 1540, 1536, 1536, 1536, 1536, 1024, 1536, 1024, 1536, 1024, 1024, 1024,
  1536, 1536, 1536, 1536, 1540, 1536, 1536, 1536, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1536, 1537, 1024, 1024, 1536, 1536, 1024, 1024, 1536, 1536, 1024, 1024, 1536, 1536, 1024, 1024,
  1552, 1552, 1040, 1024, 1552, 1536, 1040, 1024, 1536, 1536, 1024, 1024, 1536, 1536, 1024, 1024,
  1536, 1536, 1024, 1024, 1536, 1024, 1024, 1024, 1536, 1024, 1024, 1024, 1536, 1024, 1024, 1024,
  1536, 1536, 1024, 1024, 1536, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1536, 1536, 1024, 1024, 1536, 1024, 1024, 1024, 1536, 1024, 1024, 1024, 1536, 1024, 1024, 1024,
  1552, 1536, 1040, 1024, 1552, 1024, 1040, 1024, 1536, 1024, 1024, 1024, 1536, 1024, 1024, 1024,
  1536, 1536, 1024, 1024, 1536, 1024, 1024, 1024, 1536, 1024, 1024, 1024, 1536, 1024, 1024, 1024,
  1536, 1536, 1024, 1024, 1536, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1536, 1537, 1536, 1536, 1540, 1540, 1536, 1536, 1536, 1536, 1536, 1024, 1536, 1536, 1024, 1024,
  1536, 1536, 1536, 1024, 1540, 1536, 1536, 1024, 1536, 1536, 1536, 1024, 1536, 1536, 1024, 1024,
  1024, 1024, 1024, 1024, 1028, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1028, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1536, 1536, 1536, 1536, 1540, 1536, 1536, 1536, 1536, 1024, 1536, 1024, 1536, 1024, 1024, 1024,
  1536, 1024, 1536, 1024, 1540, 1024, 1536, 1024, 1536, 1024, 1536, 1024, 1536, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1028, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1028, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1536, 1537, 1024, 1024, 1536, 1536, 1024, 1024, 1536, 1536, 1024, 1024, 1536, 1536, 1024, 1024,
  1536, 1536, 1024, 1024, 1536, 1536, 1024, 1024, 1536, 1536, 1024, 1024, 1536, 1536, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1536, 1536, 1024, 1024, 1536, 1024, 1024, 1024, 1536, 1024, 1024, 1024, 1536, 1024, 1024, 1024,
  1536, 1024, 1024, 1024, 1536, 1024, 1024, 1024, 1536, 1024, 1024, 1024, 1536, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  2048, 2049, 2048, 2048, 2052, 2052, 2048, 2048, 2056, 2056, 2056, 2048, 2056, 2056, 2048, 2048,
  2064, 2064, 2064, 2048, 2068, 2064, 2064, 2048, 2064, 2064, 2064, 2048, 2064, 2064, 2048, 2048,
  2080, 2080, 2080, 2048, 2084, 2080, 2080, 2048, 2088, 2080, 2088, 2048, 2088, 2080, 2080, 2048,
  2080, 2080, 2080, 2048, 2084, 2080, 2080, 2048, 2080, 2080, 2080, 2048, 2080, 2080, 2048, 2048,
  2112, 2112, 2048, 2048, 2116, 2112, 2048, 2048, 2120, 2112, 2056, 2048, 2120, 2112, 2048, 2048,
  2128, 2112, 2064, 2048, 2132, 2112, 2064, 2048, 2128, 2112, 2064, 2048, 2128, 2112, 2048, 2048,
  2112, 2112, 2048, 2048, 2116, 2112, 2048, 2048, 2120, 2112, 2056, 2048, 2120, 2112, 2048, 2048,
  2112, 2112, 2048, 2048, 2116, 2112, 2048, 2048, 2112, 2112, 2048, 2048, 2112, 2112, 2048, 2048,
  2048, 2049, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2064, 2064, 2064, 2048, 2064, 2048, 2064, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2080, 2080, 2080, 2048, 2080, 2048, 2080, 2048, 2080, 2048, 2080, 2048, 2080, 2048, 2080, 2048,
  2080, 2080, 2080, 2048, 2080, 2048, 2080, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2112, 2112, 2048, 2048, 2112, 2048, 2048, 2048, 2112, 2048, 2048, 2048, 2112, 2048, 2048, 2048,
  2128, 2112, 2064, 2048, 2128, 2048, 2064, 2048, 2112, 2048, 2048, 2048, 2112, 2048, 2048, 2048,
  2112, 2112, 2048, 2048, 2112, 2048, 2048, 2048, 2112, 2048, 2048, 2048, 2112, 2048, 2048, 2048,
  2112, 2112, 2048, 2048, 2112, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2304, 2305, 2304, 2304, 2308, 2308, 2304, 2304, 2304, 2304, 2304, 2048, 2304, 2304, 2048, 2048,
  2304, 2304, 2304, 2048, 2308, 2304, 2304, 2048, 2304, 2304, 2304, 2048, 2304, 2304, 2048, 2048,
  2304, 2304, 2304, 2048, 2308, 2304, 2304, 2048, 2304, 2304, 2304, 2048, 2304, 2304, 2048, 2048,
  2304, 2304, 2304, 2048, 2308, 2304, 2304, 2048, 2304, 2304, 2304, 2048, 2304, 2304, 2048, 2048,
  2368, 2368, 2304, 2304, 2372, 2368, 2304, 2304, 2368, 2304, 2304, 2048, 2368, 2304, 2048, 2048,
  2368, 2304, 2304, 2048, 2372, 2304, 2304, 2048, 2368, 2304, 2304, 2048, 2368, 2304, 2048, 2048,
  2304, 2304, 2048, 2048, 2308, 2304, 2048, 2048, 2304, 2304, 2048, 2048, 2304, 2304, 2048, 2048,
  2304, 2304, 2048, 2048, 2308, 2304, 2048, 2048, 2304, 2304, 2048, 2048, 2304, 2304, 2048, 2048,
  2304, 2305, 2304, 2304, 2304, 2304, 2304, 2304, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2304, 2304, 2304, 2048, 2304, 2048, 2304, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2304, 2304, 2304, 2048, 2304, 2048, 2304, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2304, 2304, 2304, 2048, 2304, 2048, 2304, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2368, 2368, 2304, 2304, 2368, 2304, 2304, 2304, 2112, 2048, 2048, 2048, 2112, 2048, 2048, 2048,
  2368, 2304, 2304, 2048, 2368, 2048, 2304, 2048, 2112, 2048, 2048, 2048, 2112, 2048, 2048, 2048,
  2304, 2304, 2048, 2048, 2304, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2304, 2304, 2048, 2048, 2304, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2560, 2561, 2560, 2560, 2564, 2564, 2560, 2560, 2560, 2560, 2560, 2048, 2560, 2560, 2048, 2048,
  2576, 2576, 2576, 2560, 2580, 2576, 2576, 2560, 2560, 2560, 2560, 2048, 2560, 2560, 2048, 2048,
  2592, 2592, 2592, 2560, 2596, 2592, 2592, 2560, 2592, 2560, 2592, 2048, 2592, 2560, 2080, 2048,
  2592, 2592, 2592, 2560, 2596, 2592, 2592, 2560, 2560, 2560, 2560, 2048, 2560, 2560, 2048, 2048,
  2624, 2624, 2560, 2560, 2628, 2624, 2560, 2560, 2624, 2560, 2560, 2048, 2624, 2560, 2048, 2048,
  2640, 2624, 2576, 2560, 2644, 2624, 2576, 2560, 2624, 2560, 2560, 2048, 2624, 2560, 2048, 2048,
  2624, 2624, 2560, 2560, 2628, 2624, 2560, 2560, 2624, 2560, 2560, 2048, 2624, 2560, 2048, 2048,
  2624, 2624, 2560, 2560, 2628, 2624, 2560, 2560, 2560, 2560, 2048, 2048, 2560, 2560, 2048, 2048,
  2048, 2049, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2064, 2064, 2064, 2048, 2064, 2048, 2064, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2080, 2080, 2080, 2048, 2080, 2048, 2080, 2048, 2080, 2048, 2080, 2048, 2080, 2048, 2080, 2048,
  2080, 2080, 2080, 2048, 2080, 2048, 2080, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2112, 2112, 2048, 2048, 2112, 2048, 2048, 2048, 2112, 2048, 2048, 2048, 2112, 2048, 2048, 2048,
  2128, 2112, 2064, 2048, 2128, 2048, 2064, 2048, 2112, 2048, 2048, 2048, 2112, 2048, 2048, 2048,
  2112, 2112, 2048, 2048, 2112, 2048, 2048, 2048, 2112, 2048, 2048, 2048, 2112, 2048, 2048, 2048,
  2112, 2112, 2048, 2048, 2112, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2560, 2561, 2560, 2560, 2564, 2564, 2560, 2560, 2560, 2560, 2560, 2048, 2560, 2560, 2048, 2048,
  2560, 2560, 2560, 2048, 2564, 2560, 2560, 2048, 2560, 2560, 2560, 2048, 2560, 2560, 2048, 2048,
  2560, 2560, 2560, 2048, 2564, 2560, 2560, 2048, 2560, 2560, 2560, 2048, 2560, 2560, 2048, 2048,
  2560, 2560, 2560, 2048, 2564, 2560, 2560, 2048, 2560, 2560, 2560, 2048, 2560, 2560, 2048, 2048,
  2624, 2624, 2560, 2560, 2628, 2624, 2560, 2560, 2624, 2560, 2560, 2048, 2624, 2560, 2048, 2048,
  2624, 2560, 2560, 2048, 2628, 2560, 2560, 2048, 2624, 2560, 2560, 2048, 2624, 2560, 2048, 2048,
  2560, 2560, 2048, 2048, 2564, 2560, 2048, 2048, 2560, 2560, 2048, 2048, 2560, 2560, 2048, 2048,
  2560, 2560, 2048, 2048, 2564, 2560, 2048, 2048, 2560, 2560, 2048, 2048, 2560, 2560, 2048, 2048,
  2048, 2049, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2112, 2112, 2048, 2048, 2112, 2048, 2048, 2048, 2112, 2048, 2048, 2048, 2112, 2048, 2048, 2048,
  2112, 2048, 2048, 2048, 2112, 2048, 2048, 2048, 2112, 2048, 2048, 2048, 2112, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2049, 2048, 2048, 2052, 2052, 2048, 2048, 2056, 2056, 2056, 2048, 2056, 2056, 2048, 2048,
  2064, 2064, 2064, 2048, 2068, 2064, 2064, 2048, 2064, 2064, 2064, 2048, 2064, 2064, 2048, 2048,
  2048, 2048, 2048, 2048, 2052, 2048, 2048, 2048, 2056, 2048, 2056, 2048, 2056, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2052, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2052, 2048, 2048, 2048, 2056, 2048, 2056, 2048, 2056, 2048, 2048, 2048,
  2064, 2048, 2064, 2048, 2068, 2048, 2064, 2048, 2064, 2048, 2064, 2048, 2064, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2052, 2048, 2048, 2048, 2056, 2048, 2056, 2048, 2056, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2052, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2049, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2064, 2064, 2064, 2048, 2064, 2048, 2064, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2064, 2048, 2064, 2048, 2064, 2048, 2064, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2304, 2305, 2304, 2304, 2308, 2308, 2304, 2304, 2304, 2304, 2304, 2048, 2304, 2304, 2048, 2048,
  2304, 2304, 2304, 2048, 2308, 2304, 2304, 2048, 2304, 2304, 2304, 2048, 2304, 2304, 2048, 2048,
  2048, 2048, 2048, 2048, 2052, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2052, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2304, 2304, 2304, 2304, 2308, 2304, 2304, 2304, 2304, 2048, 2304, 2048, 2304, 2048, 2048, 2048,
  2304, 2048, 2304, 2048, 2308, 2048, 2304, 2048, 2304, 2048, 2304, 2048, 2304, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2052, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2052, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2304, 2305, 2304, 2304, 2304, 2304, 2304, 2304, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2304, 2304, 2304, 2048, 2304, 2048, 2304, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2304, 2304, 2304, 2304, 2304, 2304, 2304, 2304, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2304, 2048, 2304, 2048, 2304, 2048, 2304, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2560, 2561, 2560, 2560, 2564, 2564, 2560, 2560, 2560, 2560, 2560, 2048, 2560, 2560, 2048, 2048,
  2576, 2576, 2576, 2560, 2580, 2576, 2576, 2560, 2560, 2560, 2560, 2048, 2560, 2560, 2048, 2048,
  2560, 2560, 2560, 2560, 2564, 2560, 2560, 2560, 2560, 2048, 2560, 2048, 2560, 2048, 2048, 2048,
  2560, 2560, 2560, 2560, 2564, 2560, 2560, 2560, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2560, 2560, 2560, 2560, 2564, 2560, 2560, 2560, 2560, 2048, 2560, 2048, 2560, 2048, 2048, 2048,
  2576, 2560, 2576, 2560, 2580, 2560, 2576, 2560, 2560, 2048, 2560, 2048, 2560, 2048, 2048, 2048,
  2560, 2560, 2560, 2560, 2564, 2560, 2560, 2560, 2560, 2048, 2560, 2048, 2560, 2048, 2048, 2048,
  2560, 2560, 2560, 2560, 2564, 2560, 2560, 2560, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2049, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2064, 2064, 2064, 2048, 2064, 2048, 2064, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2064, 2048, 2064, 2048, 2064, 2048, 2064, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2560, 2561, 2560, 2560, 2564, 2564, 2560, 2560, 2560, 2560, 2560, 2048, 2560, 2560, 2048, 2048,
  2560, 2560, 2560, 2048, 2564, 2560, 2560, 2048, 2560, 2560, 2560, 2048, 2560, 2560, 2048, 2048,
  2048, 2048, 2048, 2048, 2052, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2052, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2560, 2560, 2560, 2560, 2564, 2560, 2560, 2560, 2560, 2048, 2560, 2048, 2560, 2048, 2048, 2048,
  2560, 2048, 2560, 2048, 2564, 2048, 2560, 2048, 2560, 2048, 2560, 2048, 2560, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2052, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2052, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2049, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048,
  4096, 4097, 4098, 4098, 4100, 4100, 4100, 4100, 4104, 4104, 4106, 4104, 4104, 4104, 4104, 4104,
  4112, 4112, 4114, 4112, 4116, 4112, 4116, 4112, 4112, 4112, 4114, 4112, 4112, 4112, 4112, 4112,
  4096, 4096, 4098, 4096, 4100, 4096, 4100, 4096, 4104, 4096, 4106, 4096, 4104, 4096, 4104, 4096,
  4096, 4096, 4098, 4096, 4100, 4096, 4100, 4096, 4096, 4096, 4098, 4096, 4096, 4096, 4096, 4096,
  4160, 4160, 4160, 4160, 4164, 4160, 4160, 4160, 4168, 4160, 4168, 4160, 4168, 4160, 4160, 4160,
  4176, 4160, 4176, 4160, 4180, 4160, 4176, 4160, 4176, 4160, 4176, 4160, 4176, 4160, 4160, 4160,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4104, 4096, 4104, 4096, 4104, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4224, 4225, 4224, 4224, 4224, 4224, 4224, 4224, 4224, 4224, 4224, 4224, 4224, 4224, 4224, 4224,
  4240, 4240, 4240, 4224, 4240, 4224, 4240, 4224, 4224, 4224, 4224, 4224, 4224, 4224, 4224, 4224,
  4224, 4224, 4224, 4096, 4224, 4096, 4224, 4096, 4224, 4096, 4224, 4096, 4224, 4096, 4224, 4096,
  4224, 4224, 4224, 4096, 4224, 4096, 4224, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4288, 4288, 4224, 4224, 4288, 4224, 4224, 4224, 4288, 4224, 4224, 4224, 4288, 4224, 4224, 4224,
  4304, 4288, 4240, 4224, 4304, 4224, 4240, 4224, 4288, 4224, 4224, 4224, 4288, 4224, 4224, 4224,
  4224, 4224, 4096, 4096, 4224, 4096, 4096, 4096, 4224, 4096, 4096, 4096, 4224, 4096, 4096, 4096,
  4224, 4224, 4096, 4096, 4224, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4097, 4098, 4098, 4100, 4100, 4100, 4100, 4096, 4096, 4098, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4098, 4096, 4100, 4096, 4100, 4096, 4096, 4096, 4098, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4098, 4096, 4100, 4096, 4100, 4096, 4096, 4096, 4098, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4098, 4096, 4100, 4096, 4100, 4096, 4096, 4096, 4098, 4096, 4096, 4096, 4096, 4096,
  4160, 4160, 4160, 4160, 4164, 4160, 4160, 4160, 4160, 4096, 4160, 4096, 4160, 4096, 4096, 4096,
  4160, 4096, 4160, 4096, 4164, 4096, 4160, 4096, 4160, 4096, 4160, 4096, 4160, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4224, 4225, 4224, 4224, 4224, 4224, 4224, 4224, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4224, 4224, 4224, 4096, 4224, 4096, 4224, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4224, 4224, 4224, 4096, 4224, 4096, 4224, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4224, 4224, 4224, 4096, 4224, 4096, 4224, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4288, 4288, 4224, 4224, 4288, 4224, 4224, 4224, 4160, 4096, 4096, 4096, 4160, 4096, 4096, 4096,
  4288, 4224, 4224, 4096, 4288, 4096, 4224, 4096, 4160, 4096, 4096, 4096, 4160, 4096, 4096, 4096,
  4224, 4224, 4096, 4096, 4224, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4224, 4224, 4096, 4096, 4224, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4608, 4609, 4610, 4610, 4612, 4612, 4612, 4612, 4608, 4608, 4610, 4608, 4608, 4608, 4608, 4608,
  4624, 4624, 4626, 4624, 4628, 4624, 4628, 4624, 4608, 4608, 4610, 4608, 4608, 4608, 4608, 4608,
  4608, 4608, 4610, 4608, 4612, 4608, 4612, 4608, 4608, 4096, 4610, 4096, 4608, 4096, 4608, 4096,
  4608, 4608, 4610, 4608, 4612, 4608, 4612, 4608, 4096, 4096, 4098, 4096, 4096, 4096, 4096, 4096,
  4672, 4672, 4672, 4672, 4676, 4672, 4672, 4672, 4672, 4608, 4672, 4608, 4672, 4608, 4608, 4608,
  4688, 4672, 4688, 4672, 4692, 4672, 4688, 4672, 4672, 4608, 4672, 4608, 4672, 4608, 4608, 4608,
  4608, 4608, 4608, 4608, 4612, 4608, 4608, 4608, 4608, 4096, 4608, 4096, 4608, 4096, 4096, 4096,
  4608, 4608, 4608, 4608, 4612, 4608, 4608, 4608, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4608, 4609, 4608, 4608, 4608, 4608, 4608, 4608, 4608, 4608, 4608, 4608, 4608, 4608, 4608, 4608,
  4624, 4624, 4624, 4608, 4624, 4608, 4624, 4608, 4608, 4608, 4608, 4608, 4608, 4608, 4608, 4608,
  4608, 4608, 4608, 4096, 4608, 4096, 4608, 4096, 4608, 4096, 4608, 4096, 4608, 4096, 4608, 4096,
  4608, 4608, 4608, 4096, 4608, 4096, 4608, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4672, 4672, 4608, 4608, 4672, 4608, 4608, 4608, 4672, 4608, 4608, 4608, 4672, 4608, 4608, 4608,
  4688, 4672, 4624, 4608, 4688, 4608, 4624, 4608, 4672, 4608, 4608, 4608, 4672, 4608, 4608, 4608,
  4608, 4608, 4096, 4096, 4608, 4096, 4096, 4096, 4608, 4096, 4096, 4096, 4608, 4096, 4096, 4096,
  4608, 4608, 4096, 4096, 4608, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4097, 4098, 4098, 4100, 4100, 4100, 4100, 4096, 4096, 4098, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4098, 4096, 4100, 4096, 4100, 4096, 4096, 4096, 4098, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4098, 4096, 4100, 4096, 4100, 4096, 4096, 4096, 4098, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4098, 4096, 4100, 4096, 4100, 4096, 4096, 4096, 4098, 4096, 4096, 4096, 4096, 4096,
  4160, 4160, 4160, 4160, 4164, 4160, 4160, 4160, 4160, 4096, 4160, 4096, 4160, 4096, 4096, 4096,
  4160, 4096, 4160, 4096, 4164, 4096, 4160, 4096, 4160, 4096, 4160, 4096, 4160, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4097, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4160, 4160, 4096, 4096, 4160, 4096, 4096, 4096, 4160, 4096, 4096, 4096, 4160, 4096, 4096, 4096,
  4160, 4096, 4096, 4096, 4160, 4096, 4096, 4096, 4160, 4096, 4096, 4096, 4160, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4097, 4096, 4096, 4100, 4100, 4096, 4096, 4104, 4104, 4104, 4096, 4104, 4104, 4096, 4096,
  4112, 4112, 4112, 4096, 4116, 4112, 4112, 4096, 4112, 4112, 4112, 4096, 4112, 4112, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4104, 4096, 4104, 4096, 4104, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4104, 4096, 4104, 4096, 4104, 4096, 4096, 4096,
  4112, 4096, 4112, 4096, 4116, 4096, 4112, 4096, 4112, 4096, 4112, 4096, 4112, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4104, 4096, 4104, 4096, 4104, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4224, 4225, 4096, 4096, 4224, 4224, 4096, 4096, 4224, 4224, 4096, 4096, 4224, 4224, 4096, 4096,
  4240, 4240, 4112, 4096, 4240, 4224, 4112, 4096, 4224, 4224, 4096, 4096, 4224, 4224, 4096, 4096,
  4224, 4224, 4096, 4096, 4224, 4096, 4096, 4096, 4224, 4096, 4096, 4096, 4224, 4096, 4096, 4096,
  4224, 4224, 4096, 4096, 4224, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4224, 4224, 4096, 4096, 4224, 4096, 4096, 4096, 4224, 4096, 4096, 4096, 4224, 4096, 4096, 4096,
  4240, 4224, 4112, 4096, 4240, 4096, 4112, 4096, 4224, 4096, 4096, 4096, 4224, 4096, 4096, 4096,
  4224, 4224, 4096, 4096, 4224, 4096, 4096, 4096, 4224, 4096, 4096, 4096, 4224, 4096, 4096, 4096,
  4224, 4224, 4096, 4096, 4224, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4097, 4096, 4096, 4100, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4224, 4225, 4096, 4096, 4224, 4224, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4224, 4224, 4096, 4096, 4224, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4224, 4224, 4096, 4096, 4224, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4224, 4224, 4096, 4096, 4224, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4224, 4224, 4096, 4096, 4224, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4224, 4224, 4096, 4096, 4224, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4224, 4224, 4096, 4096, 4224, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4224, 4224, 4096, 4096, 4224, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4608, 4609, 4608, 4608, 4612, 4612, 4608, 4608, 4608, 4608, 4608, 4096, 4608, 4608, 4096, 4096,
  4624, 4624, 4624, 4608, 4628, 4624, 4624, 4608, 4608, 4608, 4608, 4096, 4608, 4608, 4096, 4096,
  4608, 4608, 4608, 4608, 4612, 4608, 4608, 4608, 4608, 4096, 4608, 4096, 4608, 4096, 4096, 4096,
  4608, 4608, 4608, 4608, 4612, 4608, 4608, 4608, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4608, 4608, 4608, 4608, 4612, 4608, 4608, 4608, 4608, 4096, 4608, 4096, 4608, 4096, 4096, 4096,
  4624, 4608, 4624, 4608, 4628, 4608, 4624, 4608, 4608, 4096, 4608, 4096, 4608, 4096, 4096, 4096,
  4608, 4608, 4608, 4608, 4612, 4608, 4608, 4608, 4608, 4096, 4608, 4096, 4608, 4096, 4096, 4096,
  4608, 4608, 4608, 4608, 4612, 4608, 4608, 4608, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4608, 4609, 4096, 4096, 4608, 4608, 4096, 4096, 4608, 4608, 4096, 4096, 4608, 4608, 4096, 4096,
  4624, 4624, 4112, 4096, 4624, 4608, 4112, 4096, 4608, 4608, 4096, 4096, 4608, 4608, 4096, 4096,
  4608, 4608, 4096, 4096, 4608, 4096, 4096, 4096, 4608, 4096, 4096, 4096, 4608, 4096, 4096, 4096,
  4608, 4608, 4096, 4096, 4608, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4608, 4608, 4096, 4096, 4608, 4096, 4096, 4096, 4608, 4096, 4096, 4096, 4608, 4096, 4096, 4096,
  4624, 4608, 4112, 4096, 4624, 4096, 4112, 4096, 4608, 4096, 4096, 4096, 4608, 4096, 4096, 4096,
  4608, 4608, 4096, 4096, 4608, 4096, 4096, 4096, 4608, 4096, 4096, 4096, 4608, 4096, 4096, 4096,
  4608, 4608, 4096, 4096, 4608, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4097, 4096, 4096, 4100, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4097, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  6144, 6145, 6144, 6144, 6148, 6148, 6144, 6144, 6152, 6152, 6152, 6144, 6152, 6152, 6144, 6144,
  6160, 6160, 6160, 6144, 6164, 6160, 6160, 6144, 6160, 6160, 6160, 6144, 6160, 6160, 6144, 6144,
  6144, 6144, 6144, 4096, 6148, 6144, 6144, 4096, 6152, 6144, 6152, 4096, 6152, 6144, 6144, 4096,
  6144, 6144, 6144, 4096, 6148, 6144, 6144, 4096, 6144, 6144, 6144, 4096, 6144, 6144, 4096, 4096,
  6208, 6208, 6144, 6144, 6212, 6208, 6144, 6144, 6216, 6208, 6152, 6144, 6216, 6208, 6144, 6144,
  6224, 6208, 6160, 6144, 6228, 6208, 6160, 6144, 6224, 6208, 6160, 6144, 6224, 6208, 6144, 6144,
  6144, 6144, 4096, 4096, 6148, 6144, 4096, 4096, 6152, 6144, 4104, 4096, 6152, 6144, 4096, 4096,
  6144, 6144, 4096, 4096, 6148, 6144, 4096, 4096, 6144, 6144, 4096, 4096, 6144, 6144, 4096, 4096,
  6144, 6145, 6144, 6144, 6144, 6144, 6144, 6144, 6144, 6144, 6144, 6144, 6144, 6144, 6144, 6144,
  6160, 6160, 6160, 6144, 6160, 6144, 6160, 6144, 6144, 6144, 6144, 6144, 6144, 6144, 6144, 6144,
  6144, 6144, 6144, 4096, 6144, 4096, 6144, 4096, 6144, 4096, 6144, 4096, 6144, 4096, 6144, 4096,
  6144, 6144, 6144, 4096, 6144, 4096, 6144, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  6208, 6208, 6144, 6144, 6208, 6144, 6144, 6144, 6208, 6144, 6144, 6144, 6208, 6144, 6144, 6144,
  6224, 6208, 6160, 6144, 6224, 6144, 6160, 6144, 6208, 6144, 6144, 6144, 6208, 6144, 6144, 6144,
  6144, 6144, 4096, 4096, 6144, 4096, 4096, 4096, 6144, 4096, 4096, 4096, 6144, 4096, 4096, 4096,
  6144, 6144, 4096, 4096, 6144, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  6144, 6145, 6144, 6144, 6148, 6148, 6144, 6144, 6144, 6144, 6144, 4096, 6144, 6144, 4096, 4096,
  6144, 6144, 6144, 4096, 6148, 6144, 6144, 4096, 6144, 6144, 6144, 4096, 6144, 6144, 4096, 4096,
  6144, 6144, 6144, 4096, 6148, 6144, 6144, 4096, 6144, 6144, 6144, 4096, 6144, 6144, 4096, 4096,
  6144, 6144, 6144, 4096, 6148, 6144, 6144, 4096, 6144, 6144, 6144, 4096, 6144, 6144, 4096, 4096,
  6208, 6208, 6144, 6144, 6212, 6208, 6144, 6144, 6208, 6144, 6144, 4096, 6208, 6144, 4096, 4096,
  6208, 6144, 6144, 4096, 6212, 6144, 6144, 4096, 6208, 6144, 6144, 4096, 6208, 6144, 4096, 4096,
  6144, 6144, 4096, 4096, 6148, 6144, 4096, 4096, 6144, 6144, 4096, 4096, 6144, 6144, 4096, 4096,
  6144, 6144, 4096, 4096, 6148, 6144, 4096, 4096, 6144, 6144, 4096, 4096, 6144, 6144, 4096, 4096,
  6144, 6145, 6144, 6144, 6144, 6144, 6144, 6144, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  6144, 6144, 6144, 4096, 6144, 4096, 6144, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  6144, 6144, 6144, 4096, 6144, 4096, 6144, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  6144, 6144, 6144, 4096, 6144, 4096, 6144, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  6208, 6208, 6144, 6144, 6208, 6144, 6144, 6144, 4160, 4096, 4096, 4096, 4160, 4096, 4096, 4096,
  6208, 6144, 6144, 4096, 6208, 4096, 6144, 4096, 4160, 4096, 4096, 4096, 4160, 4096, 4096, 4096,
  6144, 6144, 4096, 4096, 6144, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  6144, 6144, 4096, 4096, 6144, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  6656, 6657, 6656, 6656, 6660, 6660, 6656, 6656, 6656, 6656, 6656, 6144, 6656, 6656, 6144, 6144,
  6672, 6672, 6672, 6656, 6676, 6672, 6672, 6656, 6656, 6656, 6656, 6144, 6656, 6656, 6144, 6144,
  6656, 6656, 6656, 4608, 6660, 6656, 6656, 4608, 6656, 6144, 6656, 4096, 6656, 6144, 6144, 4096,
  6656, 6656, 6656, 4608, 6660, 6656, 6656, 4608, 6144, 6144, 6144, 4096, 6144, 6144, 4096, 4096,
  6720, 6720, 6656, 6656, 6724, 6720, 6656, 6656, 6720, 6656, 6656, 6144, 6720, 6656, 6144, 6144,
  6736, 6720, 6672, 6656, 6740, 6720, 6672, 6656, 6720, 6656, 6656, 6144, 6720, 6656, 6144, 6144,
  6656, 6656, 4608, 4608, 6660, 6656, 4608, 4608, 6656, 6144, 4608, 4096, 6656, 6144, 4096, 4096,
  6656, 6656, 4608, 4608, 6660, 6656, 4608, 4608, 6144, 6144, 4096, 4096, 6144, 6144, 4096, 4096,
  6144, 6145, 6144, 6144, 6144, 6144, 6144, 6144, 6144, 6144, 6144, 6144, 6144, 6144, 6144, 6144,
  6160, 6160, 6160, 6144, 6160, 6144, 6160, 6144, 6144, 6144, 6144, 6144, 6144, 6144, 6144, 6144,
  6144, 6144, 6144, 4096, 6144, 4096, 6144, 4096, 6144, 4096, 6144, 4096, 6144, 4096, 6144, 4096,
  6144, 6144, 6144, 4096, 6144, 4096, 6144, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  6208, 6208, 6144, 6144, 6208, 6144, 6144, 6144, 6208, 6144, 6144, 6144, 6208, 6144, 6144, 6144,
  6224, 6208, 6160, 6144, 6224, 6144, 6160, 6144, 6208, 6144, 6144, 6144, 6208, 6144, 6144, 6144,
  6144, 6144, 4096, 4096, 6144, 4096, 4096, 4096, 6144, 4096, 4096, 4096, 6144, 4096, 4096, 4096,
  6144, 6144, 4096, 4096, 6144, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  6144, 6145, 6144, 6144, 6148, 6148, 6144, 6144, 6144, 6144, 6144, 4096, 6144, 6144, 4096, 4096,
  6144, 6144, 6144, 4096, 6148, 6144, 6144, 4096, 6144, 6144, 6144, 4096, 6144, 6144, 4096, 4096,
  6144, 6144, 6144, 4096, 6148, 6144, 6144, 4096, 6144, 6144, 6144, 4096, 6144, 6144, 4096, 4096,
  6144, 6144, 6144, 4096, 6148, 6144, 6144, 4096, 6144, 6144, 6144, 4096, 6144, 6144, 4096, 4096,
  6208, 6208, 6144, 6144, 6212, 6208, 6144, 6144, 6208, 6144, 6144, 4096, 6208, 6144, 4096, 4096,
  6208, 6144, 6144, 4096, 6212, 6144, 6144, 4096, 6208, 6144, 6144, 4096, 6208, 6144, 4096, 4096,
  6144, 6144, 4096, 4096, 6148, 6144, 4096, 4096, 6144, 6144, 4096, 4096, 6144, 6144, 4096, 4096,
  6144, 6144, 4096, 4096, 6148, 6144, 4096, 4096, 6144, 6144, 4096, 4096, 6144, 6144, 4096, 4096,
  4096, 4097, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4160, 4160, 4096, 4096, 4160, 4096, 4096, 4096, 4160, 4096, 4096, 4096, 4160, 4096, 4096, 4096,
  4160, 4096, 4096, 4096, 4160, 4096, 4096, 4096, 4160, 4096, 4096, 4096, 4160, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4097, 4096, 4096, 4100, 4100, 4096, 4096, 4104, 4104, 4104, 4096, 4104, 4104, 4096, 4096,
  4112, 4112, 4112, 4096, 4116, 4112, 4112, 4096, 4112, 4112, 4112, 4096, 4112, 4112, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4104, 4096, 4104, 4096, 4104, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4104, 4096, 4104, 4096, 4104, 4096, 4096, 4096,
  4112, 4096, 4112, 4096, 4116, 4096, 4112, 4096, 4112, 4096, 4112, 4096, 4112, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4104, 4096, 4104, 4096, 4104, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4097, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4112, 4112, 4112, 4096, 4112, 4096, 4112, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4112, 4096, 4112, 4096, 4112, 4096, 4112, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4097, 4096, 4096, 4100, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4097, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4608, 4609, 4608, 4608, 4612, 4612, 4608, 4608, 4608, 4608, 4608, 4096, 4608, 4608, 4096, 4096,
  4624, 4624, 4624, 4608, 4628, 4624, 4624, 4608, 4608, 4608, 4608, 4096, 4608, 4608, 4096, 4096,
  4608, 4608, 4608, 4608, 4612, 4608, 4608, 4608, 4608, 4096, 4608, 4096, 4608, 4096, 4096, 4096,
  4608, 4608, 4608, 4608, 4612, 4608, 4608, 4608, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4608, 4608, 4608, 4608, 4612, 4608, 4608, 4608, 4608, 4096, 4608, 4096, 4608, 4096, 4096, 4096,
  4624, 4608, 4624, 4608, 4628, 4608, 4624, 4608, 4608, 4096, 4608, 4096, 4608, 4096, 4096, 4096,
  4608, 4608, 4608, 4608, 4612, 4608, 4608, 4608, 4608, 4096, 4608, 4096, 4608, 4096, 4096, 4096,
  4608, 4608, 4608, 4608, 4612, 4608, 4608, 4608, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4097, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4112, 4112, 4112, 4096, 4112, 4096, 4112, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4112, 4096, 4112, 4096, 4112, 4096, 4112, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4097, 4096, 4096, 4100, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4100, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4097, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096,
  8192, 8193, 8194, 8194, 8196, 8196, 8196, 8196, 8200, 8200, 8202, 8200, 8200, 8200, 8200, 8200,
  8208, 8208, 8210, 8208, 8212, 8208, 8212, 8208, 8208, 8208, 8210, 8208, 8208, 8208, 8208, 8208,
  8224, 8224, 8226, 8224, 8228, 8224, 8228, 8224, 8232, 8224, 8234, 8224, 8232, 8224, 8232, 8224,
  8224, 8224, 8226, 8224, 8228, 8224, 8228, 8224, 8224, 8224, 8226, 8224, 8224, 8224, 8224, 8224,
  8256, 8256, 8256, 8256, 8260, 8256, 8256, 8256, 8264, 8256, 8264, 8256, 8264, 8256, 8256, 8256,
  8272, 8256, 8272, 8256, 8276, 8256, 8272, 8256, 8272, 8256, 8272, 8256, 8272, 8256, 8256, 8256,
  8256, 8256, 8256, 8256, 8260, 8256, 8256, 8256, 8264, 8256, 8264, 8256, 8264, 8256, 8256, 8256,
  8256, 8256, 8256, 8256, 8260, 8256, 8256, 8256, 8256, 8256, 8256, 8256, 8256, 8256, 8256, 8256,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8224, 8224, 8224, 8192, 8224, 8192, 8224, 8192, 8224, 8192, 8224, 8192, 8224, 8192, 8224, 8192,
  8224, 8224, 8224, 8192, 8224, 8192, 8224, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8272, 8256, 8208, 8192, 8272, 8192, 8208, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8194, 8194, 8196, 8196, 8196, 8196, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8194, 8192, 8196, 8192, 8196, 8192, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8194, 8192, 8196, 8192, 8196, 8192, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8194, 8192, 8196, 8192, 8196, 8192, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8256, 8256, 8260, 8256, 8256, 8256, 8256, 8192, 8256, 8192, 8256, 8192, 8192, 8192,
  8256, 8192, 8256, 8192, 8260, 8192, 8256, 8192, 8256, 8192, 8256, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8194, 8194, 8196, 8196, 8196, 8196, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8210, 8208, 8212, 8208, 8212, 8208, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8224, 8224, 8226, 8224, 8228, 8224, 8228, 8224, 8224, 8192, 8226, 8192, 8224, 8192, 8224, 8192,
  8224, 8224, 8226, 8224, 8228, 8224, 8228, 8224, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8256, 8256, 8260, 8256, 8256, 8256, 8256, 8192, 8256, 8192, 8256, 8192, 8192, 8192,
  8272, 8256, 8272, 8256, 8276, 8256, 8272, 8256, 8256, 8192, 8256, 8192, 8256, 8192, 8192, 8192,
  8256, 8256, 8256, 8256, 8260, 8256, 8256, 8256, 8256, 8192, 8256, 8192, 8256, 8192, 8192, 8192,
  8256, 8256, 8256, 8256, 8260, 8256, 8256, 8256, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8224, 8224, 8224, 8192, 8224, 8192, 8224, 8192, 8224, 8192, 8224, 8192, 8224, 8192, 8224, 8192,
  8224, 8224, 8224, 8192, 8224, 8192, 8224, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8272, 8256, 8208, 8192, 8272, 8192, 8208, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8194, 8194, 8196, 8196, 8196, 8196, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8194, 8192, 8196, 8192, 8196, 8192, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8194, 8192, 8196, 8192, 8196, 8192, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8194, 8192, 8196, 8192, 8196, 8192, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8256, 8256, 8260, 8256, 8256, 8256, 8256, 8192, 8256, 8192, 8256, 8192, 8192, 8192,
  8256, 8192, 8256, 8192, 8260, 8192, 8256, 8192, 8256, 8192, 8256, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8200, 8200, 8200, 8192, 8200, 8200, 8192, 8192,
  8208, 8208, 8208, 8192, 8212, 8208, 8208, 8192, 8208, 8208, 8208, 8192, 8208, 8208, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8200, 8192, 8200, 8192, 8200, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8200, 8192, 8200, 8192, 8200, 8192, 8192, 8192,
  8208, 8192, 8208, 8192, 8212, 8192, 8208, 8192, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8200, 8192, 8200, 8192, 8200, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8192, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8212, 8208, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8192, 8208, 8192, 8212, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8192, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8200, 8200, 8200, 8192, 8200, 8200, 8192, 8192,
  8208, 8208, 8208, 8192, 8212, 8208, 8208, 8192, 8208, 8208, 8208, 8192, 8208, 8208, 8192, 8192,
  8224, 8224, 8224, 8192, 8228, 8224, 8224, 8192, 8232, 8224, 8232, 8192, 8232, 8224, 8224, 8192,
  8224, 8224, 8224, 8192, 8228, 8224, 8224, 8192, 8224, 8224, 8224, 8192, 8224, 8224, 8192, 8192,
  8256, 8256, 8192, 8192, 8260, 8256, 8192, 8192, 8264, 8256, 8200, 8192, 8264, 8256, 8192, 8192,
  8272, 8256, 8208, 8192, 8276, 8256, 8208, 8192, 8272, 8256, 8208, 8192, 8272, 8256, 8192, 8192,
  8256, 8256, 8192, 8192, 8260, 8256, 8192, 8192, 8264, 8256, 8200, 8192, 8264, 8256, 8192, 8192,
  8256, 8256, 8192, 8192, 8260, 8256, 8192, 8192, 8256, 8256, 8192, 8192, 8256, 8256, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8224, 8224, 8224, 8192, 8224, 8192, 8224, 8192, 8224, 8192, 8224, 8192, 8224, 8192, 8224, 8192,
  8224, 8224, 8224, 8192, 8224, 8192, 8224, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8272, 8256, 8208, 8192, 8272, 8192, 8208, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8260, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8192, 8192, 8192, 8260, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8212, 8208, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8224, 8224, 8224, 8192, 8228, 8224, 8224, 8192, 8224, 8192, 8224, 8192, 8224, 8192, 8224, 8192,
  8224, 8224, 8224, 8192, 8228, 8224, 8224, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8260, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8272, 8256, 8208, 8192, 8276, 8256, 8208, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8260, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8260, 8256, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8224, 8224, 8224, 8192, 8224, 8192, 8224, 8192, 8224, 8192, 8224, 8192, 8224, 8192, 8224, 8192,
  8224, 8224, 8224, 8192, 8224, 8192, 8224, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8272, 8256, 8208, 8192, 8272, 8192, 8208, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8260, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8192, 8192, 8192, 8260, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8200, 8200, 8200, 8192, 8200, 8200, 8192, 8192,
  8208, 8208, 8208, 8192, 8212, 8208, 8208, 8192, 8208, 8208, 8208, 8192, 8208, 8208, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8200, 8192, 8200, 8192, 8200, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8200, 8192, 8200, 8192, 8200, 8192, 8192, 8192,
  8208, 8192, 8208, 8192, 8212, 8192, 8208, 8192, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8200, 8192, 8200, 8192, 8200, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8192, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8212, 8208, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8192, 8208, 8192, 8212, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8192, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8194, 8194, 8196, 8196, 8196, 8196, 8200, 8200, 8202, 8200, 8200, 8200, 8200, 8200,
  8208, 8208, 8210, 8208, 8212, 8208, 8212, 8208, 8208, 8208, 8210, 8208, 8208, 8208, 8208, 8208,
  8192, 8192, 8194, 8192, 8196, 8192, 8196, 8192, 8200, 8192, 8202, 8192, 8200, 8192, 8200, 8192,
  8192, 8192, 8194, 8192, 8196, 8192, 8196, 8192, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8256, 8256, 8260, 8256, 8256, 8256, 8264, 8256, 8264, 8256, 8264, 8256, 8256, 8256,
  8272, 8256, 8272, 8256, 8276, 8256, 8272, 8256, 8272, 8256, 8272, 8256, 8272, 8256, 8256, 8256,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8200, 8192, 8200, 8192, 8200, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8272, 8256, 8208, 8192, 8272, 8192, 8208, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8194, 8194, 8196, 8196, 8196, 8196, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8194, 8192, 8196, 8192, 8196, 8192, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8194, 8192, 8196, 8192, 8196, 8192, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8194, 8192, 8196, 8192, 8196, 8192, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8256, 8256, 8260, 8256, 8256, 8256, 8256, 8192, 8256, 8192, 8256, 8192, 8192, 8192,
  8256, 8192, 8256, 8192, 8260, 8192, 8256, 8192, 8256, 8192, 8256, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8194, 8194, 8196, 8196, 8196, 8196, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8210, 8208, 8212, 8208, 8212, 8208, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8194, 8192, 8196, 8192, 8196, 8192, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8194, 8192, 8196, 8192, 8196, 8192, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8256, 8256, 8260, 8256, 8256, 8256, 8256, 8192, 8256, 8192, 8256, 8192, 8192, 8192,
  8272, 8256, 8272, 8256, 8276, 8256, 8272, 8256, 8256, 8192, 8256, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8272, 8256, 8208, 8192, 8272, 8192, 8208, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8194, 8194, 8196, 8196, 8196, 8196, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8194, 8192, 8196, 8192, 8196, 8192, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8194, 8192, 8196, 8192, 8196, 8192, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8194, 8192, 8196, 8192, 8196, 8192, 8192, 8192, 8194, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8256, 8256, 8260, 8256, 8256, 8256, 8256, 8192, 8256, 8192, 8256, 8192, 8192, 8192,
  8256, 8192, 8256, 8192, 8260, 8192, 8256, 8192, 8256, 8192, 8256, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8200, 8200, 8200, 8192, 8200, 8200, 8192, 8192,
  8208, 8208, 8208, 8192, 8212, 8208, 8208, 8192, 8208, 8208, 8208, 8192, 8208, 8208, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8200, 8192, 8200, 8192, 8200, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8200, 8192, 8200, 8192, 8200, 8192, 8192, 8192,
  8208, 8192, 8208, 8192, 8212, 8192, 8208, 8192, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8200, 8192, 8200, 8192, 8200, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8192, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8212, 8208, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8192, 8208, 8192, 8212, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8192, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8200, 8200, 8200, 8192, 8200, 8200, 8192, 8192,
  8208, 8208, 8208, 8192, 8212, 8208, 8208, 8192, 8208, 8208, 8208, 8192, 8208, 8208, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8200, 8192, 8200, 8192, 8200, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8260, 8256, 8192, 8192, 8264, 8256, 8200, 8192, 8264, 8256, 8192, 8192,
  8272, 8256, 8208, 8192, 8276, 8256, 8208, 8192, 8272, 8256, 8208, 8192, 8272, 8256, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8200, 8192, 8200, 8192, 8200, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8272, 8256, 8208, 8192, 8272, 8192, 8208, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8260, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8192, 8192, 8192, 8260, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8212, 8208, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8260, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8272, 8256, 8208, 8192, 8276, 8256, 8208, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8272, 8256, 8208, 8192, 8272, 8192, 8208, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8260, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8192, 8192, 8192, 8260, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8256, 8256, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192, 8256, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8200, 8200, 8200, 8192, 8200, 8200, 8192, 8192,
  8208, 8208, 8208, 8192, 8212, 8208, 8208, 8192, 8208, 8208, 8208, 8192, 8208, 8208, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8200, 8192, 8200, 8192, 8200, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8200, 8192, 8200, 8192, 8200, 8192, 8192, 8192,
  8208, 8192, 8208, 8192, 8212, 8192, 8208, 8192, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8200, 8192, 8200, 8192, 8200, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8192, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8212, 8208, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8192, 8208, 8192, 8212, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8208, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8208, 8192, 8208, 8192, 8208, 8192, 8208, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8196, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8196, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8193, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192,
  8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192
};
}
}
}

#endif
