# スマートテキスト

テキストとマークアップを組み合わせる最も簡単な方法は <a name="smarttext">スマートテキストモード</a> を使うことです。

スマートテキストプラグインを有効化します。

    require 'slim/smart'

自動的に `:implicit_text` オプションが有効になることで,
次のように簡単にテキストを入力できるようになります:

    p
      This is text.

小文字のタグ名や暗黙的なテキスト行などの特殊文字で始まっていない行を
Slim に自動的に処理させることができます。
テキストが複数行にわたる場合, 単にそれらをインデントします。

    p
      This is text,
        and it spans
        several lines.

`>` を使って明示的にテキストをマークすることもできます。
例えば, 小文字や特殊文字で始まっている場合,
テキストが複数行にわたる場合,
単に見た目の一貫性のために,
タグ名に大文字を使いたい場合,
`:implicit_text` オプションを無効にしたままにする必要がある場合です。

    p
      > 'This is text, too.'
    p
      >
        This is text
        which spans
        several lines.

`:smart_text_escaping` が有効化されている限り,
エスケープされるべきテキストは自動的にエスケープされます。
しかし, 不便にならないように検出された HTML エンティティはそのまま使われます。
この方法はいつでも HTML のエスケープを気にすることのない,
最も理想的な方法です。

    h1 Questions & Answers
    footer
      Copyright &copy; #{Time.now.year}

スマートテキストの素晴らしいところの 1 つはマークアップとよくミックスしているところです。
スマートテキストの行は通常改行を維持するので,
強調やリンクのような他のタグを簡単に混ぜ合わせて使うことができます:

    p
      Your credit card
      strong will not
      > be charged now.
    p
      Check
      a href=r(:faq) our FAQ
      > for more info.

(タグから小文字のテキストを区別する場合明示的なテキストを示すインジケーター `>` の使用には注意してください)。

インラインタグのまわりにスペースを入れたくない場合があります。
幸いなことにスマートテキストはこの一般的なケースを処理できます。
スマートテキストのブロックが `:smart_text_begin_chars` で指定 (デフォルトは `,.;:!?)]}`)
された文字で始まる場合には先頭の改行が行われません。
同様に, スマートテキストのブロックが `:smart_text_begin_chars` で指定 (デフォルトは `,.;:!?)]}`)
された文字で終わる場合には改行されません。
これによって通常のテキストとリンクや span タグを混在させることがとても容易になります:

    p
      Please proceed to
      a href="/" our homepage
      .
    p
      Status: failed (
      a href="#1" details
      ).

スマートテキストはタグのショートカットをも把握しているので,
次のような場合にも正しく対応します:

    .class
      #id
        #{'More'}
        i text
        ...

当然のことながら, これは短いテキストのスニペットでより便利に作業できることを意味しています。
ほとんどがテキストのコンテンツの場合, Markdown や Textile のような
ビルトインの埋め込みエンジンを使う方が良いでしょう。

## オプション

| 種類 | 名前 | デフォルト | 用途 |
| ---- | ---- | ---------- | ---- |
| 真偽値 | :implicit_text | true | 暗黙的テキストの判別を有効化 |
| 真偽値 | :smart_text | true | スマートテキストによる処理を有効化 |
| 文字列 | :smart_text_begin_chars | ',.;:!?)]}' | スマートテキストで先頭の改行を抑制する文字 |
| 文字列 | :smart_text_end_chars | '([{' | スマートテキストで末尾の改行を抑制する文字 |
| 真偽値 | :smart_text_escaping | true | 設定すると, スマートテキスト中のエスケープが必要な HTML 文字は自動的にエスケープされる |
