/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common;

import com.google.common.collect.Lists;
import com.google.common.math.DoubleMath;
import java.util.List;
import java.util.Objects;
import org.eclipse.elk.alg.common.TEdge;
import org.eclipse.elk.core.math.KVector;

public class TTriangle {
    public final KVector a;
    public final KVector b;
    public final KVector c;
    public final List<TEdge> tEdges;
    public final List<KVector> vertices;
    private KVector circumcenter;

    public TTriangle(KVector a, KVector b, KVector c) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.tEdges = Lists.newArrayList(new TEdge(a, b), new TEdge(b, c), new TEdge(c, a));
        this.vertices = Lists.newArrayList(a, b, c);
        this.circumcenter = this.calculateCircumcenter();
    }

    public KVector getCircumcenter() {
        return this.circumcenter;
    }

    private KVector calculateCircumcenter() {
        KVector ab = this.b.clone().sub(this.a);
        KVector ac = this.c.clone().sub(this.a);
        KVector bc = this.c.clone().sub(this.b);
        double e = ab.x * (this.a.x + this.b.x) + ab.y * (this.a.y + this.b.y);
        double f = ac.x * (this.a.x + this.c.x) + ac.y * (this.a.y + this.c.y);
        double g2 = 2.0 * (ab.x * bc.y - ab.y * bc.x);
        double px = (ac.y * e - ab.y * f) / g2;
        double py = (ab.x * f - ac.x * e) / g2;
        return new KVector(px, py);
    }

    public boolean inCircumcircle(KVector v) {
        return DoubleMath.fuzzyCompare(this.circumcenter.distance(v), this.circumcenter.distance(this.a), 1.0E-4) < 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TTriangle) {
            TTriangle other = (TTriangle)obj;
            return this.contains(other.a) && this.contains(other.b) && this.contains(other.c);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.a) + Objects.hashCode(this.b) + Objects.hashCode(this.c);
    }

    public boolean contains(TEdge tEdge) {
        return Objects.equals(tEdge, this.tEdges.get(0)) || Objects.equals(tEdge, this.tEdges.get(1)) || Objects.equals(tEdge, this.tEdges.get(2));
    }

    public boolean contains(KVector vertex) {
        return Objects.equals(vertex, this.vertices.get(0)) || Objects.equals(vertex, this.vertices.get(1)) || Objects.equals(vertex, this.vertices.get(2));
    }
}

