/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.security;

import net.sourceforge.plantuml.security.SecurityUtils;

public enum SecurityProfile {
    SANDBOX,
    ALLOWLIST,
    INTERNET,
    LEGACY,
    UNSECURE;


    static SecurityProfile init() {
        String env = SecurityUtils.getenv("PLANTUML_SECURITY_PROFILE");
        if ("SANDBOX".equalsIgnoreCase(env)) {
            return SANDBOX;
        }
        if ("ALLOWLIST".equalsIgnoreCase(env)) {
            return ALLOWLIST;
        }
        if ("INTERNET".equalsIgnoreCase(env)) {
            return INTERNET;
        }
        if ("UNSECURE".equalsIgnoreCase(env)) {
            return UNSECURE;
        }
        return LEGACY;
    }

    public String longDescription() {
        switch (this.ordinal()) {
            case 0: {
                return "This is completely safe: no access to local files or to distant URL.";
            }
            case 1: {
                return "Some local resource may be accessible.";
            }
            case 2: {
                return "<i>Mode designed for server connected to Internet.";
            }
            case 3: {
                return "<b>Warning: this mode will be removed in future version";
            }
            case 4: {
                return "<b>Make sure that this server is not accessible from Internet";
            }
        }
        return "<i>This is completely safe: no access on local files or on distant URL.";
    }

    public long getTimeout() {
        switch (this.ordinal()) {
            case 0: {
                return 1000L;
            }
            case 1: {
                return 300000L;
            }
            case 2: {
                return 10000L;
            }
            case 3: {
                return 60000L;
            }
            case 4: {
                return 300000L;
            }
        }
        throw new AssertionError();
    }

    public boolean canWeReadThisEnvironmentVariable(String name) {
        if (name == null) {
            return false;
        }
        String lname = name.toLowerCase();
        if (lname.startsWith("plantuml.security")) {
            return false;
        }
        if (lname.startsWith("plantuml")) {
            return true;
        }
        if (lname.equals("path.separator") || lname.equals("line.separator")) {
            return true;
        }
        return this == UNSECURE;
    }
}

