/*
 * Decompiled with CFR 0.152.
 */
package jcckit.util;

import java.lang.reflect.Constructor;
import jcckit.util.ConfigParameters;
import jcckit.util.FactoryException;

public class Factory {
    public static final String CLASS_NAME_KEY = "className";

    private Factory() {
    }

    public static Object create(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (Throwable t2) {
            throw new IllegalArgumentException("Could not create an instance of " + className + " because of " + t2);
        }
    }

    public static Object create(ConfigParameters configParameters) {
        String className = configParameters.get(CLASS_NAME_KEY);
        return Factory.createObject(configParameters, className);
    }

    public static Object create(ConfigParameters configParameters, String defaultClassName) {
        String className = configParameters.get(CLASS_NAME_KEY, defaultClassName);
        return Factory.createObject(configParameters, className);
    }

    public static Object createOrGet(ConfigParameters configParameters, Object defaultObject) {
        String className = configParameters.get(CLASS_NAME_KEY, null);
        return className == null ? defaultObject : Factory.createObject(configParameters, className);
    }

    private static Object createObject(ConfigParameters configParameters, String className) {
        try {
            Class<?> c = Class.forName(className);
            Object result = null;
            Constructor<?> constructor = null;
            try {
                constructor = c.getConstructor(ConfigParameters.class);
                result = constructor.newInstance(configParameters);
            }
            catch (NoSuchMethodException e) {
                result = c.newInstance();
            }
            return result;
        }
        catch (Throwable t2) {
            throw new FactoryException(configParameters, CLASS_NAME_KEY, t2);
        }
    }
}

