/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.reflections.ReflectionsException;
import org.reflections.util.Utils;

public class Store {
    private final ConcurrentHashMap<String, Map<String, Collection<String>>> storeMap = new ConcurrentHashMap();

    protected Store() {
    }

    public Set<String> keySet() {
        return this.storeMap.keySet();
    }

    private Map<String, Collection<String>> get(String index) {
        Map<String, Collection<String>> mmap = this.storeMap.get(index);
        if (mmap == null) {
            throw new ReflectionsException("Scanner " + index + " was not configured");
        }
        return mmap;
    }

    public Set<String> get(Class<?> scannerClass, String key) {
        return this.get(Utils.index(scannerClass), Collections.singletonList(key));
    }

    public Set<String> get(String index, String key) {
        return this.get(index, Collections.singletonList(key));
    }

    public Set<String> get(Class<?> scannerClass, Collection<String> keys2) {
        return this.get(Utils.index(scannerClass), keys2);
    }

    private Set<String> get(String index, Collection<String> keys2) {
        Map<String, Collection<String>> mmap = this.get(index);
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        for (String key : keys2) {
            Collection<String> values2 = mmap.get(key);
            if (values2 == null) continue;
            result2.addAll(values2);
        }
        return result2;
    }

    public Set<String> getAllIncluding(Class<?> scannerClass, Collection<String> keys2) {
        String index = Utils.index(scannerClass);
        Map<String, Collection<String>> mmap = this.get(index);
        ArrayList<String> workKeys = new ArrayList<String>(keys2);
        HashSet<String> result2 = new HashSet<String>();
        for (int i = 0; i < workKeys.size(); ++i) {
            Collection<String> values2;
            String key = (String)workKeys.get(i);
            if (!result2.add(key) || (values2 = mmap.get(key)) == null) continue;
            workKeys.addAll(values2);
        }
        return result2;
    }

    public Set<String> getAll(Class<?> scannerClass, String key) {
        return this.getAllIncluding(scannerClass, this.get(scannerClass, key));
    }

    public Set<String> getAll(Class<?> scannerClass, Collection<String> keys2) {
        return this.getAllIncluding(scannerClass, this.get(scannerClass, keys2));
    }

    public Set<String> keys(String index) {
        Map<String, Collection<String>> map = this.storeMap.get(index);
        return map != null ? new HashSet<String>(map.keySet()) : Collections.emptySet();
    }

    public Set<String> values(String index) {
        Map<String, Collection<String>> map = this.storeMap.get(index);
        return map != null ? map.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()) : Collections.emptySet();
    }

    public boolean put(Class<?> scannerClass, String key, String value) {
        return this.put(Utils.index(scannerClass), key, value);
    }

    public boolean put(String index, String key, String value) {
        return this.storeMap.computeIfAbsent(index, s2 -> new ConcurrentHashMap()).computeIfAbsent(key, s2 -> new ArrayList()).add(value);
    }

    void merge(Store store) {
        if (store != null) {
            for (String indexName : store.keySet()) {
                Map<String, Collection<String>> index = store.get(indexName);
                if (index == null) continue;
                for (String key : index.keySet()) {
                    for (String string : index.get(key)) {
                        this.put(indexName, key, string);
                    }
                }
            }
        }
    }
}

