/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.streaming.windowing.assigner;

import java.util.Collections;
import java.util.List;
import org.opensearch.sql.planner.streaming.windowing.Window;
import org.opensearch.sql.planner.streaming.windowing.assigner.WindowAssigner;
import org.opensearch.sql.utils.DateTimeUtils;
import shaded.com.google.common.base.Preconditions;

public class TumblingWindowAssigner
implements WindowAssigner {
    private final long windowSize;

    public TumblingWindowAssigner(long windowSize) {
        Preconditions.checkArgument(windowSize > 0L, "Window size [%s] must be positive number", windowSize);
        this.windowSize = windowSize;
    }

    @Override
    public List<Window> assign(long timestamp) {
        long startTime = DateTimeUtils.getWindowStartTime(timestamp, this.windowSize);
        return Collections.singletonList(new Window(startTime, startTime + this.windowSize));
    }
}

