/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.physical;

import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.immutables.value.Value;
import org.opensearch.sql.opensearch.planner.physical.ImmutableOpenSearchAggregateIndexScanRule;
import org.opensearch.sql.opensearch.planner.physical.OpenSearchIndexScanRule;
import org.opensearch.sql.opensearch.storage.scan.CalciteLogicalIndexScan;

@Value.Enclosing
public class OpenSearchAggregateIndexScanRule
extends RelRule<Config> {
    protected OpenSearchAggregateIndexScanRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        if (call.rels.length != 2) {
            throw new AssertionError((Object)String.format("The length of rels should be %s but got %s", this.operands.size(), call.rels.length));
        }
        LogicalAggregate aggregate = (LogicalAggregate)call.rel(0);
        CalciteLogicalIndexScan scan = (CalciteLogicalIndexScan)call.rel(1);
        this.apply(call, aggregate, scan);
    }

    protected void apply(RelOptRuleCall call, LogicalAggregate aggregate, CalciteLogicalIndexScan scan) {
        CalciteLogicalIndexScan newScan = scan.pushDownAggregate(aggregate);
        if (newScan != null) {
            call.transformTo(newScan);
        }
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableOpenSearchAggregateIndexScanRule.Config.builder().build().withOperandSupplier(b0 -> b0.operand(LogicalAggregate.class).oneInput(b1 -> b1.operand(CalciteLogicalIndexScan.class).predicate(Predicate.not(OpenSearchIndexScanRule::isLimitPushed).and(OpenSearchIndexScanRule::noAggregatePushed)).noInputs()));

        @Override
        default public OpenSearchAggregateIndexScanRule toRule() {
            return new OpenSearchAggregateIndexScanRule(this);
        }
    }
}

