/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.rewriter.nestedfield;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import org.opensearch.sql.legacy.rewriter.nestedfield.SQLClause;
import org.opensearch.sql.legacy.rewriter.nestedfield.Scope;

class Where
extends SQLClause<SQLBinaryOpExpr> {
    Where(SQLBinaryOpExpr expr) {
        super(expr);
    }

    @Override
    void rewrite(Scope scope2) {
        if (this.isLeftChildCondition()) {
            if (this.isChildTagEquals(scope2)) {
                this.useAnyChildTag(scope2);
            } else {
                this.left().mergeNestedField(scope2);
                this.right().mergeNestedField(scope2);
            }
        }
        this.mergeIfHaveTagAndIsRootOfWhereOrNot(scope2);
    }

    private boolean isLeftChildCondition() {
        return ((SQLBinaryOpExpr)this.expr).getLeft() instanceof SQLBinaryOpExpr;
    }

    private boolean isChildTagEquals(Scope scope2) {
        String left = scope2.getConditionTag((SQLBinaryOpExpr)((SQLBinaryOpExpr)this.expr).getLeft());
        String right = scope2.getConditionTag((SQLBinaryOpExpr)((SQLBinaryOpExpr)this.expr).getRight());
        return left.equals(right);
    }

    private void useAnyChildTag(Scope scope2) {
        scope2.addConditionTag((SQLBinaryOpExpr)this.expr, scope2.getConditionTag((SQLBinaryOpExpr)((SQLBinaryOpExpr)this.expr).getLeft()));
    }

    private void mergeIfHaveTagAndIsRootOfWhereOrNot(Scope scope2) {
        if (scope2.getConditionTag((SQLBinaryOpExpr)this.expr).isEmpty()) {
            return;
        }
        if (((SQLBinaryOpExpr)this.expr).getParent() instanceof MySqlSelectQueryBlock || ((SQLBinaryOpExpr)this.expr).getParent() instanceof SQLNotExpr) {
            this.mergeNestedField(scope2);
        }
    }

    private Where left() {
        return new Where((SQLBinaryOpExpr)((SQLBinaryOpExpr)this.expr).getLeft());
    }

    private Where right() {
        return new Where((SQLBinaryOpExpr)((SQLBinaryOpExpr)this.expr).getRight());
    }

    private void mergeNestedField(Scope scope2) {
        String tag = scope2.getConditionTag((SQLBinaryOpExpr)this.expr);
        if (!tag.isEmpty()) {
            if (this.isLeftChildCondition()) {
                this.replaceByNestedFunction((SQLExpr)this.expr).getParameters().add(0, new SQLCharExpr(tag));
            } else {
                this.replaceByNestedFunction(((SQLBinaryOpExpr)this.expr).getLeft(), this.pathFromIdentifier(((SQLBinaryOpExpr)this.expr).getLeft()));
            }
        }
    }
}

