/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.domain;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.util.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.script.Script;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.search.aggregations.PipelineAggregatorBuilders;
import org.opensearch.sql.legacy.domain.Condition;
import org.opensearch.sql.legacy.domain.Field;
import org.opensearch.sql.legacy.domain.KVValue;
import org.opensearch.sql.legacy.domain.MethodField;
import org.opensearch.sql.legacy.domain.Where;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.parser.HavingParser;
import org.opensearch.sql.legacy.parser.NestedType;
import org.opensearch.sql.legacy.parser.WhereParser;
import shaded.com.google.common.collect.Iterables;

public class Having {
    private static final String BUCKET_SELECTOR_NAME = "bucket_filter";
    private static final String PARAMS = "params.";
    private static final String AND = " && ";
    private static final String OR = " || ";
    private final List<Where> conditions;
    private final HavingParser havingParser;

    public List<Field> getHavingFields() {
        return this.havingParser.getHavingFields();
    }

    public Having(SQLExpr havingExpr, WhereParser parser) throws SqlParseException {
        this.havingParser = new HavingParser(parser);
        this.conditions = this.parseHavingExprToConditions(havingExpr, this.havingParser);
    }

    public List<Where> getConditions() {
        return this.conditions;
    }

    public Having(SQLSelectGroupByClause groupByExpr, WhereParser parser) throws SqlParseException {
        this(groupByExpr == null ? null : groupByExpr.getHaving(), parser);
    }

    public void explain(AggregationBuilder groupByAgg, List<Field> fields2) throws SqlParseException {
        if (groupByAgg == null || this.conditions.isEmpty()) {
            return;
        }
        groupByAgg.subAggregation((PipelineAggregationBuilder)PipelineAggregatorBuilders.bucketSelector((String)BUCKET_SELECTOR_NAME, this.contextForFieldsInSelect(Iterables.concat(fields2, this.getHavingFields())), (Script)this.explainConditions()));
    }

    private List<Where> parseHavingExprToConditions(SQLExpr havingExpr, HavingParser parser) throws SqlParseException {
        if (havingExpr == null) {
            return Collections.emptyList();
        }
        Where where = Where.newInstance();
        parser.parseWhere(havingExpr, where);
        return where.getWheres();
    }

    private Map<String, String> contextForFieldsInSelect(Iterable<Field> fields2) {
        HashMap<String, String> context = new HashMap<String, String>();
        for (Field field : fields2) {
            if (!(field instanceof MethodField)) continue;
            context.put(field.getAlias(), this.bucketsPath(field.getAlias(), ((MethodField)field).getParams()));
        }
        return context;
    }

    private Script explainConditions() throws SqlParseException {
        return new Script(this.doExplain(this.conditions));
    }

    private String doExplain(List<Where> wheres) throws SqlParseException {
        if (wheres == null || wheres.isEmpty()) {
            return "";
        }
        StringBuilder script = new StringBuilder();
        for (Where cond : wheres) {
            if (script.length() > 0) {
                script.append(cond.getConn() == Where.CONN.AND ? AND : OR);
            }
            if (cond instanceof Condition) {
                script.append(this.createScript((Condition)cond));
                continue;
            }
            script.append('(').append(this.doExplain(cond.getWheres())).append(')');
        }
        return script.toString();
    }

    private String createScript(Condition cond) throws SqlParseException {
        String name = cond.getName();
        Object value = cond.getValue();
        switch (cond.getOPERATOR()) {
            case EQ: 
            case GT: 
            case LT: 
            case GTE: 
            case LTE: 
            case IS: 
            case ISN: {
                return this.expr(name, cond.getOpertatorSymbol(), value);
            }
            case N: {
                return this.expr(name, "!=", value);
            }
            case BETWEEN: {
                Object[] values2 = (Object[])value;
                return this.expr(name, ">=", values2[0]) + AND + this.expr(name, "<=", values2[1]);
            }
            case NBETWEEN: {
                Object[] values3 = (Object[])value;
                return this.expr(name, "<", values3[0]) + OR + this.expr(name, ">", values3[1]);
            }
            case IN: {
                return Arrays.stream((Object[])value).map(val -> this.expr(name, "==", val)).collect(Collectors.joining(OR));
            }
            case NIN: {
                return Arrays.stream((Object[])value).map(val -> this.expr(name, "!=", val)).collect(Collectors.joining(AND));
            }
        }
        throw new SqlParseException("Unsupported operation in HAVING clause: " + String.valueOf((Object)cond.getOPERATOR()));
    }

    private String expr(String name, String operator, Object value) {
        return String.join((CharSequence)" ", PARAMS + name, operator, value.toString());
    }

    private String bucketsPath(String alias, List<KVValue> kvValueList) {
        if (kvValueList.size() == 1) {
            KVValue kvValue = kvValueList.get(0);
            if (StringUtils.equals(kvValue.key, "nested") && kvValue.value instanceof NestedType) {
                return ((NestedType)kvValue.value).getBucketPath();
            }
        }
        return alias;
    }
}

