/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class UnixTimestampFunction
extends ImplementorUDF {
    public UnixTimestampFunction() {
        super(new UnixTimestampImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return ReturnTypes.DOUBLE_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return UDFOperandMetadata.wrap((CompositeOperandTypeChecker)((Object)OperandTypes.DATETIME.or(OperandTypes.NUMERIC).or(OperandTypes.family(new SqlTypeFamily[0]))));
    }

    public static double unixTimestamp(FunctionProperties properties2) {
        return DateTimeFunctions.unixTimeStamp(properties2.getQueryStartClock()).doubleValue();
    }

    public static double unixTimestamp(FunctionProperties ignored, ExprValue timestamp) {
        return DateTimeFunctions.unixTimeStampOf(timestamp).doubleValue();
    }

    public static class UnixTimestampImplementor
    implements NotNullImplementor {
        @Override
        public Expression implement(RexToLixTranslator rexToLixTranslator, RexCall rexCall, List<Expression> list) {
            List<Expression> operands = UserDefinedFunctionUtils.convertToExprValues(list, rexCall);
            List<Expression> operandsWithProperties = UserDefinedFunctionUtils.prependFunctionProperties(operands, rexToLixTranslator);
            return Expressions.call(UnixTimestampFunction.class, "unixTimestamp", operandsWithProperties);
        }
    }
}

