/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.opensearch.sql.calcite.utils.PPLReturnTypes;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.calcite.utils.datetime.DateTimeConversionUtils;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class TimestampFunction
extends ImplementorUDF {
    public TimestampFunction() {
        super(new TimestampImplementor(), NullPolicy.ALL);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return PPLReturnTypes.TIMESTAMP_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return UDFOperandMetadata.wrap((CompositeOperandTypeChecker)((Object)OperandTypes.STRING.or(OperandTypes.DATETIME).or(OperandTypes.STRING_STRING).or(OperandTypes.family(SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME)).or(OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.DATETIME)).or(OperandTypes.family(SqlTypeFamily.DATETIME, SqlTypeFamily.STRING))));
    }

    public static String timestamp(FunctionProperties properties2, ExprValue datetime) {
        return (String)DateTimeConversionUtils.convertToTimestampValue(datetime, properties2).valueForCalcite();
    }

    public static String timestamp(FunctionProperties properties2, ExprValue datetime, ExprValue addTime) {
        ExprTimestampValue dateTimeBase = DateTimeConversionUtils.convertToTimestampValue(datetime, properties2);
        ExprTimestampValue addTimeValue = DateTimeConversionUtils.convertToTimestampValue(addTime, properties2);
        return (String)DateTimeFunctions.exprAddTime(properties2, dateTimeBase, addTimeValue).valueForCalcite();
    }

    public static class TimestampImplementor
    implements NotNullImplementor {
        @Override
        public Expression implement(RexToLixTranslator rexToLixTranslator, RexCall rexCall, List<Expression> list) {
            List<Expression> operands = UserDefinedFunctionUtils.convertToExprValues(list, rexCall);
            List<Expression> operandsWithProperties = UserDefinedFunctionUtils.prependFunctionProperties(operands, rexToLixTranslator);
            return Expressions.call(TimestampFunction.class, "timestamp", operandsWithProperties);
        }
    }
}

