/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.PPLReturnTypes;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.calcite.utils.datetime.DateTimeConversionUtils;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class LastDayFunction
extends ImplementorUDF {
    public LastDayFunction() {
        super(new LastDayImplementor(), NullPolicy.ARG0);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return PPLReturnTypes.DATE_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return UDFOperandMetadata.wrap((CompositeOperandTypeChecker)((Object)OperandTypes.DATETIME.or(OperandTypes.STRING)));
    }

    public static class LastDayImplementor
    implements NotNullImplementor {
        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> operands) {
            List<Expression> exprOperands = UserDefinedFunctionUtils.convertToExprValues(operands, call);
            List<Expression> exprOperandsWithProperties = UserDefinedFunctionUtils.prependFunctionProperties(exprOperands, translator);
            Expression properties2 = exprOperandsWithProperties.get(0);
            Expression datetime = exprOperandsWithProperties.get(1);
            ExprType datetimeType = OpenSearchTypeFactory.convertRelDataTypeToExprType(call.getOperands().getFirst().getType());
            if (ExprCoreType.TIME == datetimeType) {
                return Expressions.call(LastDayImplementor.class, "lastDayToday", new Expression[]{properties2});
            }
            MethodCallExpression dateValue = Expressions.call(DateTimeConversionUtils.class, "convertToDateValue", new Expression[]{datetime, properties2});
            return Expressions.call(LastDayImplementor.class, "lastDay", new Expression[]{dateValue});
        }

        public static String lastDayToday(FunctionProperties properties2) {
            return (String)DateTimeFunctions.exprLastDayToday(properties2.getQueryStartClock()).valueForCalcite();
        }

        public static String lastDay(ExprValue dateValue) {
            return (String)DateTimeFunctions.exprLastDay(dateValue).valueForCalcite();
        }
    }
}

