/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.DSL;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.BuiltinFunctionName;

public class HighlightExpression
extends FunctionExpression {
    private final Expression highlightField;
    private final ExprType type;

    public HighlightExpression(Expression highlightField) {
        super(BuiltinFunctionName.HIGHLIGHT.getName(), List.of(highlightField));
        this.highlightField = highlightField;
        this.type = this.highlightField.toString().contains("*") ? ExprCoreType.STRUCT : ExprCoreType.ARRAY;
    }

    @Override
    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
        Object refName = "_highlight";
        if (this.type == ExprCoreType.ARRAY) {
            refName = (String)refName + "." + StringUtils.unquoteText(this.getHighlightField().toString());
        }
        ExprValue value = valueEnv.resolve(DSL.ref((String)refName, ExprCoreType.STRING));
        if (this.type == ExprCoreType.STRUCT && value.type() == ExprCoreType.STRUCT && (value = new ExprTupleValue(new LinkedHashMap<String, ExprValue>(value.tupleValue().entrySet().stream().filter(s2 -> this.matchesHighlightRegex((String)s2.getKey(), StringUtils.unquoteText(this.highlightField.toString()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (ExprValue)e.getValue()))))).tupleValue().isEmpty()) {
            value = ExprValueUtils.missingValue();
        }
        return value;
    }

    @Override
    public ExprType type() {
        return this.type;
    }

    @Override
    public <T, C> T accept(ExpressionNodeVisitor<T, C> visitor2, C context) {
        return visitor2.visitHighlight(this, context);
    }

    private boolean matchesHighlightRegex(String field, String pattern) {
        Pattern p = Pattern.compile(pattern.replace("*", ".*"));
        Matcher matcher = p.matcher(field);
        return matcher.matches();
    }

    @Generated
    public Expression getHighlightField() {
        return this.highlightField;
    }

    @Generated
    public ExprType getType() {
        return this.type;
    }
}

