/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.model;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import lombok.Generated;
import org.opensearch.sql.data.model.AbstractExprValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.utils.DateTimeFormatters;
import shaded.com.google.common.base.Objects;

public class ExprDateValue
extends AbstractExprValue {
    private final LocalDate date;

    public ExprDateValue(String date) {
        try {
            this.date = LocalDate.parse(date, DateTimeFormatters.DATE_TIME_FORMATTER_VARIABLE_NANOS_OPTIONAL);
        }
        catch (DateTimeParseException e) {
            throw new SemanticCheckException(String.format("date:%s in unsupported format, please use 'yyyy-MM-dd'", date));
        }
    }

    @Override
    public String value() {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(this.date);
    }

    @Override
    public ExprType type() {
        return ExprCoreType.DATE;
    }

    @Override
    public LocalDate dateValue() {
        return this.date;
    }

    @Override
    public LocalTime timeValue() {
        return LocalTime.of(0, 0, 0);
    }

    @Override
    public Instant timestampValue() {
        return ZonedDateTime.of(this.date, this.timeValue(), ZoneOffset.UTC).toInstant();
    }

    @Override
    public boolean isDateTime() {
        return true;
    }

    public String toString() {
        return String.format("DATE '%s'", this.value());
    }

    @Override
    public int compare(ExprValue other) {
        return this.date.compareTo(other.dateValue());
    }

    @Override
    public boolean equal(ExprValue other) {
        return this.date.equals(other.dateValue());
    }

    public int hashCode() {
        return Objects.hashCode(this.date);
    }

    @Generated
    public ExprDateValue(LocalDate date) {
        this.date = date;
    }
}

