/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.mcpserver.requests.register;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.transport.mcpserver.requests.McpToolBaseInput;

public class McpToolRegisterInput
extends McpToolBaseInput {
    @Generated
    private static final Logger log = LogManager.getLogger(McpToolRegisterInput.class);
    public static final String TYPE_NOT_SHOWN_EXCEPTION_MESSAGE = "type field required";

    public McpToolRegisterInput(StreamInput streamInput) throws IOException {
        super(streamInput);
        if (super.getType() == null) {
            throw new IllegalArgumentException(TYPE_NOT_SHOWN_EXCEPTION_MESSAGE);
        }
    }

    public McpToolRegisterInput(String name, String type2, String description2, Map<String, Object> parameters2, Map<String, Object> attributes, Instant createdTime, Instant lastUpdateTime) {
        super(name, type2, description2, parameters2, attributes, createdTime, lastUpdateTime);
        if (type2 == null) {
            throw new IllegalArgumentException(TYPE_NOT_SHOWN_EXCEPTION_MESSAGE);
        }
    }

    public static McpToolRegisterInput parse(XContentParser parser) throws IOException {
        String type2 = null;
        String name = null;
        String description2 = null;
        Map params = null;
        Map attributes = null;
        Instant createdTime = null;
        Instant lastUpdateTime = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "type": {
                    type2 = parser.text();
                    continue block18;
                }
                case "name": {
                    name = parser.text();
                    continue block18;
                }
                case "description": {
                    description2 = parser.textOrNull();
                    continue block18;
                }
                case "parameters": {
                    params = parser.map();
                    continue block18;
                }
                case "attributes": {
                    attributes = parser.map();
                    continue block18;
                }
                case "create_time": {
                    createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block18;
                }
                case "last_update_time": {
                    lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block18;
                }
            }
            parser.skipChildren();
        }
        return new McpToolRegisterInput(name, type2, description2, params, attributes, createdTime, lastUpdateTime);
    }
}

