/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input.parameter.textembedding;

import java.io.IOException;
import java.util.Locale;
import lombok.Generated;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.annotation.MLAlgoParameter;
import org.opensearch.ml.common.input.parameter.MLAlgoParams;

@MLAlgoParameter(algorithms={FunctionName.TEXT_EMBEDDING})
public class AsymmetricTextEmbeddingParameters
implements MLAlgoParams {
    public static final String PARSE_FIELD_NAME = FunctionName.TEXT_EMBEDDING.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(MLAlgoParams.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> AsymmetricTextEmbeddingParameters.parse(it));
    public static final String EMBEDDING_CONTENT_TYPE_FIELD = "content_type";
    private EmbeddingContentType embeddingContentType;

    public AsymmetricTextEmbeddingParameters(EmbeddingContentType embeddingContentType) {
        this.embeddingContentType = embeddingContentType;
    }

    public AsymmetricTextEmbeddingParameters(StreamInput in) throws IOException {
        this.embeddingContentType = EmbeddingContentType.valueOf(in.readOptionalString());
    }

    public static MLAlgoParams parse(XContentParser parser) throws IOException {
        EmbeddingContentType embeddingContentType = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block6: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "content_type": {
                    String contentType = parser.text();
                    embeddingContentType = EmbeddingContentType.valueOf(contentType.toUpperCase(Locale.ROOT));
                    continue block6;
                }
            }
            parser.skipChildren();
        }
        return new AsymmetricTextEmbeddingParameters(embeddingContentType);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.embeddingContentType.name());
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        xContentBuilder.startObject();
        if (this.embeddingContentType != null) {
            xContentBuilder.field(EMBEDDING_CONTENT_TYPE_FIELD, this.embeddingContentType.name());
        }
        xContentBuilder.endObject();
        return xContentBuilder;
    }

    public EmbeddingContentType getEmbeddingContentType() {
        return this.embeddingContentType;
    }

    @Generated
    public static AsymmetricTextEmbeddingParametersBuilder builder() {
        return new AsymmetricTextEmbeddingParametersBuilder();
    }

    @Generated
    public AsymmetricTextEmbeddingParametersBuilder toBuilder() {
        return new AsymmetricTextEmbeddingParametersBuilder().embeddingContentType(this.embeddingContentType);
    }

    @Generated
    public void setEmbeddingContentType(EmbeddingContentType embeddingContentType) {
        this.embeddingContentType = embeddingContentType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsymmetricTextEmbeddingParameters)) {
            return false;
        }
        AsymmetricTextEmbeddingParameters other = (AsymmetricTextEmbeddingParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EmbeddingContentType this$embeddingContentType = this.getEmbeddingContentType();
        EmbeddingContentType other$embeddingContentType = other.getEmbeddingContentType();
        return !(this$embeddingContentType == null ? other$embeddingContentType != null : !((Object)((Object)this$embeddingContentType)).equals((Object)other$embeddingContentType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AsymmetricTextEmbeddingParameters;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        EmbeddingContentType $embeddingContentType = this.getEmbeddingContentType();
        result2 = result2 * 59 + ($embeddingContentType == null ? 43 : ((Object)((Object)$embeddingContentType)).hashCode());
        return result2;
    }

    @Generated
    public String toString() {
        return "AsymmetricTextEmbeddingParameters(embeddingContentType=" + String.valueOf((Object)this.getEmbeddingContentType()) + ")";
    }

    public static enum EmbeddingContentType {
        QUERY,
        PASSAGE;

    }

    @Generated
    public static class AsymmetricTextEmbeddingParametersBuilder {
        @Generated
        private EmbeddingContentType embeddingContentType;

        @Generated
        AsymmetricTextEmbeddingParametersBuilder() {
        }

        @Generated
        public AsymmetricTextEmbeddingParametersBuilder embeddingContentType(EmbeddingContentType embeddingContentType) {
            this.embeddingContentType = embeddingContentType;
            return this;
        }

        @Generated
        public AsymmetricTextEmbeddingParameters build() {
            return new AsymmetricTextEmbeddingParameters(this.embeddingContentType);
        }

        @Generated
        public String toString() {
            return "AsymmetricTextEmbeddingParameters.AsymmetricTextEmbeddingParametersBuilder(embeddingContentType=" + String.valueOf((Object)this.embeddingContentType) + ")";
        }
    }
}

