/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.connector;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.connector.RetryBackoffPolicy;

public class ConnectorClientConfig
implements ToXContentObject,
Writeable {
    public static final String MAX_CONNECTION_FIELD = "max_connection";
    public static final String CONNECTION_TIMEOUT_FIELD = "connection_timeout";
    public static final String READ_TIMEOUT_FIELD = "read_timeout";
    public static final String RETRY_BACKOFF_MILLIS_FIELD = "retry_backoff_millis";
    public static final String RETRY_TIMEOUT_SECONDS_FIELD = "retry_timeout_seconds";
    public static final String MAX_RETRY_TIMES_FIELD = "max_retry_times";
    public static final String RETRY_BACKOFF_POLICY_FIELD = "retry_backoff_policy";
    public static final Integer MAX_CONNECTION_DEFAULT_VALUE = 30;
    public static final Integer CONNECTION_TIMEOUT_DEFAULT_VALUE = 30000;
    public static final Integer READ_TIMEOUT_DEFAULT_VALUE = 30000;
    public static final Integer RETRY_BACKOFF_MILLIS_DEFAULT_VALUE = 200;
    public static final Integer RETRY_TIMEOUT_SECONDS_DEFAULT_VALUE = 30;
    public static final Integer MAX_RETRY_TIMES_DEFAULT_VALUE = 0;
    public static final RetryBackoffPolicy RETRY_BACKOFF_POLICY_DEFAULT_VALUE = RetryBackoffPolicy.CONSTANT;
    public static final Version MINIMAL_SUPPORTED_VERSION_FOR_RETRY = Version.V_2_15_0;
    private Integer maxConnections;
    private Integer connectionTimeout;
    private Integer readTimeout;
    private Integer retryBackoffMillis;
    private Integer retryTimeoutSeconds;
    private Integer maxRetryTimes;
    private RetryBackoffPolicy retryBackoffPolicy;

    public ConnectorClientConfig(Integer maxConnections, Integer connectionTimeout, Integer readTimeout, Integer retryBackoffMillis, Integer retryTimeoutSeconds, Integer maxRetryTimes, RetryBackoffPolicy retryBackoffPolicy) {
        this.maxConnections = maxConnections;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.retryBackoffMillis = retryBackoffMillis;
        this.retryTimeoutSeconds = retryTimeoutSeconds;
        this.maxRetryTimes = maxRetryTimes;
        this.retryBackoffPolicy = retryBackoffPolicy;
    }

    public ConnectorClientConfig(StreamInput input) throws IOException {
        Version streamInputVersion = input.getVersion();
        this.maxConnections = input.readOptionalInt();
        this.connectionTimeout = input.readOptionalInt();
        this.readTimeout = input.readOptionalInt();
        if (streamInputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_RETRY)) {
            this.retryBackoffMillis = input.readOptionalInt();
            this.retryTimeoutSeconds = input.readOptionalInt();
            this.maxRetryTimes = input.readOptionalInt();
            if (input.readBoolean()) {
                this.retryBackoffPolicy = RetryBackoffPolicy.from(input.readString());
            }
        }
    }

    public ConnectorClientConfig() {
        this.maxConnections = MAX_CONNECTION_DEFAULT_VALUE;
        this.connectionTimeout = CONNECTION_TIMEOUT_DEFAULT_VALUE;
        this.readTimeout = READ_TIMEOUT_DEFAULT_VALUE;
        this.retryBackoffMillis = RETRY_BACKOFF_MILLIS_DEFAULT_VALUE;
        this.retryTimeoutSeconds = RETRY_TIMEOUT_SECONDS_DEFAULT_VALUE;
        this.maxRetryTimes = MAX_RETRY_TIMES_DEFAULT_VALUE;
        this.retryBackoffPolicy = RETRY_BACKOFF_POLICY_DEFAULT_VALUE;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeOptionalInt(this.maxConnections);
        out.writeOptionalInt(this.connectionTimeout);
        out.writeOptionalInt(this.readTimeout);
        if (streamOutputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_RETRY)) {
            out.writeOptionalInt(this.retryBackoffMillis);
            out.writeOptionalInt(this.retryTimeoutSeconds);
            out.writeOptionalInt(this.maxRetryTimes);
            if (Objects.nonNull((Object)this.retryBackoffPolicy)) {
                out.writeBoolean(true);
                out.writeString(this.retryBackoffPolicy.name());
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        XContentBuilder builder = xContentBuilder.startObject();
        if (this.maxConnections != null) {
            builder.field(MAX_CONNECTION_FIELD, this.maxConnections);
        }
        if (this.connectionTimeout != null) {
            builder.field(CONNECTION_TIMEOUT_FIELD, this.connectionTimeout);
        }
        if (this.readTimeout != null) {
            builder.field(READ_TIMEOUT_FIELD, this.readTimeout);
        }
        if (this.retryBackoffMillis != null) {
            builder.field(RETRY_BACKOFF_MILLIS_FIELD, this.retryBackoffMillis);
        }
        if (this.retryTimeoutSeconds != null) {
            builder.field(RETRY_TIMEOUT_SECONDS_FIELD, this.retryTimeoutSeconds);
        }
        if (this.maxRetryTimes != null) {
            builder.field(MAX_RETRY_TIMES_FIELD, this.maxRetryTimes);
        }
        if (this.retryBackoffPolicy != null) {
            builder.field(RETRY_BACKOFF_POLICY_FIELD, this.retryBackoffPolicy.name().toLowerCase(Locale.ROOT));
        }
        return builder.endObject();
    }

    public static ConnectorClientConfig fromStream(StreamInput in) throws IOException {
        ConnectorClientConfig connectorClientConfig = new ConnectorClientConfig(in);
        return connectorClientConfig;
    }

    public static ConnectorClientConfig parse(XContentParser parser) throws IOException {
        Integer maxConnections = MAX_CONNECTION_DEFAULT_VALUE;
        Integer connectionTimeout = CONNECTION_TIMEOUT_DEFAULT_VALUE;
        Integer readTimeout = READ_TIMEOUT_DEFAULT_VALUE;
        Integer retryBackoffMillis = RETRY_BACKOFF_MILLIS_DEFAULT_VALUE;
        Integer retryTimeoutSeconds = RETRY_TIMEOUT_SECONDS_DEFAULT_VALUE;
        Integer maxRetryTimes = MAX_RETRY_TIMES_DEFAULT_VALUE;
        RetryBackoffPolicy retryBackoffPolicy = RETRY_BACKOFF_POLICY_DEFAULT_VALUE;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "max_connection": {
                    maxConnections = parser.intValue();
                    continue block18;
                }
                case "connection_timeout": {
                    connectionTimeout = parser.intValue();
                    continue block18;
                }
                case "read_timeout": {
                    readTimeout = parser.intValue();
                    continue block18;
                }
                case "retry_backoff_millis": {
                    retryBackoffMillis = parser.intValue();
                    continue block18;
                }
                case "retry_timeout_seconds": {
                    retryTimeoutSeconds = parser.intValue();
                    continue block18;
                }
                case "max_retry_times": {
                    maxRetryTimes = parser.intValue();
                    continue block18;
                }
                case "retry_backoff_policy": {
                    retryBackoffPolicy = RetryBackoffPolicy.from(parser.text());
                    continue block18;
                }
            }
            parser.skipChildren();
        }
        return ConnectorClientConfig.builder().maxConnections(maxConnections).connectionTimeout(connectionTimeout).readTimeout(readTimeout).retryBackoffMillis(retryBackoffMillis).retryTimeoutSeconds(retryTimeoutSeconds).maxRetryTimes(maxRetryTimes).retryBackoffPolicy(retryBackoffPolicy).build();
    }

    @Generated
    public static ConnectorClientConfigBuilder builder() {
        return new ConnectorClientConfigBuilder();
    }

    @Generated
    public ConnectorClientConfigBuilder toBuilder() {
        return new ConnectorClientConfigBuilder().maxConnections(this.maxConnections).connectionTimeout(this.connectionTimeout).readTimeout(this.readTimeout).retryBackoffMillis(this.retryBackoffMillis).retryTimeoutSeconds(this.retryTimeoutSeconds).maxRetryTimes(this.maxRetryTimes).retryBackoffPolicy(this.retryBackoffPolicy);
    }

    @Generated
    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    @Generated
    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Generated
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Generated
    public Integer getRetryBackoffMillis() {
        return this.retryBackoffMillis;
    }

    @Generated
    public Integer getRetryTimeoutSeconds() {
        return this.retryTimeoutSeconds;
    }

    @Generated
    public Integer getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    @Generated
    public RetryBackoffPolicy getRetryBackoffPolicy() {
        return this.retryBackoffPolicy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectorClientConfig)) {
            return false;
        }
        ConnectorClientConfig other = (ConnectorClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maxConnections = this.getMaxConnections();
        Integer other$maxConnections = other.getMaxConnections();
        if (this$maxConnections == null ? other$maxConnections != null : !((Object)this$maxConnections).equals(other$maxConnections)) {
            return false;
        }
        Integer this$connectionTimeout = this.getConnectionTimeout();
        Integer other$connectionTimeout = other.getConnectionTimeout();
        if (this$connectionTimeout == null ? other$connectionTimeout != null : !((Object)this$connectionTimeout).equals(other$connectionTimeout)) {
            return false;
        }
        Integer this$readTimeout = this.getReadTimeout();
        Integer other$readTimeout = other.getReadTimeout();
        if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
            return false;
        }
        Integer this$retryBackoffMillis = this.getRetryBackoffMillis();
        Integer other$retryBackoffMillis = other.getRetryBackoffMillis();
        if (this$retryBackoffMillis == null ? other$retryBackoffMillis != null : !((Object)this$retryBackoffMillis).equals(other$retryBackoffMillis)) {
            return false;
        }
        Integer this$retryTimeoutSeconds = this.getRetryTimeoutSeconds();
        Integer other$retryTimeoutSeconds = other.getRetryTimeoutSeconds();
        if (this$retryTimeoutSeconds == null ? other$retryTimeoutSeconds != null : !((Object)this$retryTimeoutSeconds).equals(other$retryTimeoutSeconds)) {
            return false;
        }
        Integer this$maxRetryTimes = this.getMaxRetryTimes();
        Integer other$maxRetryTimes = other.getMaxRetryTimes();
        if (this$maxRetryTimes == null ? other$maxRetryTimes != null : !((Object)this$maxRetryTimes).equals(other$maxRetryTimes)) {
            return false;
        }
        RetryBackoffPolicy this$retryBackoffPolicy = this.getRetryBackoffPolicy();
        RetryBackoffPolicy other$retryBackoffPolicy = other.getRetryBackoffPolicy();
        return !(this$retryBackoffPolicy == null ? other$retryBackoffPolicy != null : !((Object)((Object)this$retryBackoffPolicy)).equals((Object)other$retryBackoffPolicy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConnectorClientConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Integer $maxConnections = this.getMaxConnections();
        result2 = result2 * 59 + ($maxConnections == null ? 43 : ((Object)$maxConnections).hashCode());
        Integer $connectionTimeout = this.getConnectionTimeout();
        result2 = result2 * 59 + ($connectionTimeout == null ? 43 : ((Object)$connectionTimeout).hashCode());
        Integer $readTimeout = this.getReadTimeout();
        result2 = result2 * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        Integer $retryBackoffMillis = this.getRetryBackoffMillis();
        result2 = result2 * 59 + ($retryBackoffMillis == null ? 43 : ((Object)$retryBackoffMillis).hashCode());
        Integer $retryTimeoutSeconds = this.getRetryTimeoutSeconds();
        result2 = result2 * 59 + ($retryTimeoutSeconds == null ? 43 : ((Object)$retryTimeoutSeconds).hashCode());
        Integer $maxRetryTimes = this.getMaxRetryTimes();
        result2 = result2 * 59 + ($maxRetryTimes == null ? 43 : ((Object)$maxRetryTimes).hashCode());
        RetryBackoffPolicy $retryBackoffPolicy = this.getRetryBackoffPolicy();
        result2 = result2 * 59 + ($retryBackoffPolicy == null ? 43 : ((Object)((Object)$retryBackoffPolicy)).hashCode());
        return result2;
    }

    @Generated
    public static class ConnectorClientConfigBuilder {
        @Generated
        private Integer maxConnections;
        @Generated
        private Integer connectionTimeout;
        @Generated
        private Integer readTimeout;
        @Generated
        private Integer retryBackoffMillis;
        @Generated
        private Integer retryTimeoutSeconds;
        @Generated
        private Integer maxRetryTimes;
        @Generated
        private RetryBackoffPolicy retryBackoffPolicy;

        @Generated
        ConnectorClientConfigBuilder() {
        }

        @Generated
        public ConnectorClientConfigBuilder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        @Generated
        public ConnectorClientConfigBuilder connectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        @Generated
        public ConnectorClientConfigBuilder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Generated
        public ConnectorClientConfigBuilder retryBackoffMillis(Integer retryBackoffMillis) {
            this.retryBackoffMillis = retryBackoffMillis;
            return this;
        }

        @Generated
        public ConnectorClientConfigBuilder retryTimeoutSeconds(Integer retryTimeoutSeconds) {
            this.retryTimeoutSeconds = retryTimeoutSeconds;
            return this;
        }

        @Generated
        public ConnectorClientConfigBuilder maxRetryTimes(Integer maxRetryTimes) {
            this.maxRetryTimes = maxRetryTimes;
            return this;
        }

        @Generated
        public ConnectorClientConfigBuilder retryBackoffPolicy(RetryBackoffPolicy retryBackoffPolicy) {
            this.retryBackoffPolicy = retryBackoffPolicy;
            return this;
        }

        @Generated
        public ConnectorClientConfig build() {
            return new ConnectorClientConfig(this.maxConnections, this.connectionTimeout, this.readTimeout, this.retryBackoffMillis, this.retryTimeoutSeconds, this.maxRetryTimes, this.retryBackoffPolicy);
        }

        @Generated
        public String toString() {
            return "ConnectorClientConfig.ConnectorClientConfigBuilder(maxConnections=" + this.maxConnections + ", connectionTimeout=" + this.connectionTimeout + ", readTimeout=" + this.readTimeout + ", retryBackoffMillis=" + this.retryBackoffMillis + ", retryTimeoutSeconds=" + this.retryTimeoutSeconds + ", maxRetryTimes=" + this.maxRetryTimes + ", retryBackoffPolicy=" + String.valueOf((Object)this.retryBackoffPolicy) + ")";
        }
    }
}

