/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import org.opensearch.common.ssl.SslConfigException;

final class PemUtils {
    PemUtils() {
        throw new IllegalStateException("Utility class should not be instantiated");
    }

    public static PrivateKey readPrivateKey(Path keyPath, Supplier<char[]> passwordSupplier) throws IOException, PKCSException {
        PrivateKeyInfo pki = PemUtils.loadPrivateKeyFromFile(keyPath, passwordSupplier);
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        return converter.getPrivateKey(pki);
    }

    static List<Certificate> readCertificates(Collection<Path> certPaths) throws CertificateException, IOException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ArrayList<Certificate> certificates = new ArrayList<Certificate>(certPaths.size());
        for (Path path : certPaths) {
            InputStream input = Files.newInputStream(path, new OpenOption[0]);
            try {
                Collection<? extends Certificate> parsed = certFactory.generateCertificates(input);
                if (parsed.isEmpty()) {
                    throw new SslConfigException("Failed to parse any certificate from [" + String.valueOf(path.toAbsolutePath()) + "]");
                }
                certificates.addAll(parsed);
            }
            finally {
                if (input == null) continue;
                input.close();
            }
        }
        return certificates;
    }

    private static PrivateKeyInfo loadPrivateKeyFromFile(Path keyPath, Supplier<char[]> passwordSupplier) throws IOException, PKCSException {
        try (PEMParser pemParser = new PEMParser((Reader)Files.newBufferedReader(keyPath, StandardCharsets.UTF_8));){
            Object object = PemUtils.readObject(keyPath, pemParser);
            if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
                PKCS8EncryptedPrivateKeyInfo privateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)object;
                InputDecryptorProvider inputDecryptorProvider = new JcePKCSPBEInputDecryptorProviderBuilder().setProvider("BCFIPS").build(passwordSupplier.get());
                PrivateKeyInfo privateKeyInfo2 = privateKeyInfo.decryptPrivateKeyInfo(inputDecryptorProvider);
                return privateKeyInfo2;
            }
            if (object instanceof PEMEncryptedKeyPair) {
                PEMEncryptedKeyPair encryptedKeyPair = (PEMEncryptedKeyPair)object;
                PEMDecryptorProvider decryptorProvider = new JcePEMDecryptorProviderBuilder().setProvider("BCFIPS").build(passwordSupplier.get());
                PEMKeyPair keyPair = encryptedKeyPair.decryptKeyPair(decryptorProvider);
                PrivateKeyInfo privateKeyInfo = keyPair.getPrivateKeyInfo();
                return privateKeyInfo;
            }
            if (object instanceof PEMKeyPair) {
                PrivateKeyInfo privateKeyInfo = ((PEMKeyPair)object).getPrivateKeyInfo();
                return privateKeyInfo;
            }
            if (object instanceof PrivateKeyInfo) {
                PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)object;
                return privateKeyInfo;
            }
            throw new SslConfigException(String.format(Locale.ROOT, "error parsing private key [%s], invalid encrypted private key class: [%s]", keyPath.toAbsolutePath(), object.getClass().getName()));
        }
    }

    private static Object readObject(Path keyPath, PEMParser pemParser) throws IOException {
        while (pemParser.ready()) {
            try {
                Object object = pemParser.readObject();
                if (object == null || object instanceof ASN1ObjectIdentifier) continue;
                return object;
            }
            catch (IOException iOException) {
            }
        }
        throw new SslConfigException("Error parsing Private Key [" + String.valueOf(keyPath.toAbsolutePath()) + "]. The file is empty, or does not contain expected key format.");
    }

    static {
        int highestPriority = 1;
        if (Security.getProvider("BCFIPS") == null) {
            Security.insertProviderAt(new BouncyCastleFipsProvider(), highestPriority++);
        }
        if (Security.getProvider("BCJSSE") == null) {
            Security.insertProviderAt((Provider)new BouncyCastleJsseProvider(), highestPriority);
        }
    }
}

