/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.fips.Scrypt;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseKDFSecretKeyFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.spec.ScryptKeySpec;

class ProvPBESCRYPT
extends AlgorithmProvider {
    private static final String PREFIX = ProvPBESCRYPT.class.getName();

    ProvPBESCRYPT() {
    }

    @Override
    public void configure(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.SCRYPT", PREFIX + "$ScryptWithUTF8", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseScrypt();
            }
        });
        bouncyCastleFipsProvider.addAlias("SecretKeyFactory", "SCRYPT", "SCRYPTWITHUTF8");
        bouncyCastleFipsProvider.addAlias("SecretKeyFactory", "SCRYPT", MiscObjectIdentifiers.id_scrypt);
    }

    static class BaseScrypt
    extends BaseKDFSecretKeyFactory {
        private Scrypt.KDFFactory sFact = new Scrypt.KDFFactory();

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof ScryptKeySpec) {
                ScryptKeySpec scryptKeySpec = (ScryptKeySpec)keySpec;
                if (scryptKeySpec.getSalt() == null) {
                    throw new InvalidKeySpecException("Salt S must be provided.");
                }
                if (scryptKeySpec.getCostParameter() <= 1) {
                    throw new InvalidKeySpecException("Cost parameter N must be > 1.");
                }
                if (scryptKeySpec.getKeyLength() <= 0) {
                    throw new InvalidKeySpecException("positive key length required: " + scryptKeySpec.getKeyLength());
                }
                Scrypt.Parameters parameters2 = Scrypt.ALGORITHM.using(scryptKeySpec.getSalt(), scryptKeySpec.getCostParameter(), scryptKeySpec.getBlockSize(), scryptKeySpec.getParallelizationParameter(), PasswordConverter.UTF8, scryptKeySpec.getPassword());
                byte[] byArray = new byte[(scryptKeySpec.getKeyLength() + 7) / 8];
                try {
                    this.sFact.createKDFCalculator(parameters2).generateBytes(byArray);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidKeySpecException(illegalArgumentException.getMessage(), illegalArgumentException);
                }
                return new SecretKeySpec(byArray, "SCRYPT");
            }
            if (keySpec == null) {
                throw new InvalidKeySpecException("KeySpec cannot be null");
            }
            throw new InvalidKeySpecException("Invalid KeySpec: " + keySpec.getClass().getName());
        }
    }
}

