/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import shaded.com.google.common.collect.BoundType;
import shaded.com.google.common.collect.ImmutableRangeSet;
import shaded.com.google.common.collect.Range;
import shaded.com.google.common.collect.RangeSet;
import shaded.com.google.common.collect.TreeRangeSet;

public class RangeSets {
    private static final ImmutableRangeSet ALL = ImmutableRangeSet.of().complement();

    private RangeSets() {
    }

    public static <C extends Comparable<C>> RangeSet<C> minus(RangeSet<C> rangeSet, Range<C> range) {
        TreeRangeSet<C> mutableRangeSet = TreeRangeSet.create(rangeSet);
        mutableRangeSet.remove(range);
        return mutableRangeSet.equals(rangeSet) ? rangeSet : ImmutableRangeSet.copyOf(mutableRangeSet);
    }

    public static <C extends Comparable<C>> RangeSet<C> rangeSetAll() {
        return ALL;
    }

    public static <C extends Comparable<C>> int compare(RangeSet<C> s0, RangeSet<C> s1) {
        Range<C> r1;
        Range<C> r0;
        int c;
        Iterator<Range<C>> i0 = s0.asRanges().iterator();
        Iterator<Range<C>> i1 = s1.asRanges().iterator();
        do {
            boolean h0 = i0.hasNext();
            boolean h1 = i1.hasNext();
            if (h0 && h1) continue;
            return Boolean.compare(h0, h1);
        } while ((c = RangeSets.compare(r0 = i0.next(), r1 = i1.next())) == 0);
        return c;
    }

    public static <C extends Comparable<C>> int compare(Range<C> r0, Range<C> r1) {
        int c = Boolean.compare(r0.hasLowerBound(), r1.hasLowerBound());
        if (c != 0) {
            return c;
        }
        if (r0.hasLowerBound()) {
            c = r0.lowerEndpoint().compareTo(r1.lowerEndpoint());
            if (c != 0) {
                return c;
            }
            c = r0.lowerBoundType().compareTo(r1.lowerBoundType());
            if (c != 0) {
                return c;
            }
        }
        if ((c = Boolean.compare(r0.hasUpperBound(), r1.hasUpperBound())) != 0) {
            return -c;
        }
        if (r0.hasUpperBound()) {
            c = r0.upperEndpoint().compareTo(r1.upperEndpoint());
            if (c != 0) {
                return c;
            }
            c = r0.upperBoundType().compareTo(r1.upperBoundType());
            if (c != 0) {
                return c;
            }
        }
        return 0;
    }

    public static <C extends Comparable<C>> int hashCode(RangeSet<C> rangeSet) {
        int h2 = 1;
        for (Range<C> r : rangeSet.asRanges()) {
            h2 = 31 * h2 + r.hashCode();
        }
        return h2;
    }

    public static <C extends Comparable<C>> boolean isPoint(Range<C> range) {
        return range.hasLowerBound() && range.hasUpperBound() && range.lowerEndpoint().compareTo(range.upperEndpoint()) == 0 && !range.isEmpty();
    }

    public static <C extends Comparable<C>> boolean isOpenInterval(RangeSet<C> rangeSet) {
        if (rangeSet.isEmpty()) {
            return false;
        }
        Set<Range<C>> ranges = rangeSet.asRanges();
        Range<C> range = ranges.iterator().next();
        return ranges.size() == 1 && (!range.hasLowerBound() || !range.hasUpperBound());
    }

    public static <C extends Comparable<C>> int countPoints(RangeSet<C> rangeSet) {
        int n = 0;
        for (Range<C> range : rangeSet.asRanges()) {
            if (!RangeSets.isPoint(range)) continue;
            ++n;
        }
        return n;
    }

    public static <C extends Comparable<C>, C2 extends Comparable<C2>> RangeSet<C2> map(RangeSet<C> rangeSet, Handler<C, Range<C2>> handler) {
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        rangeSet.asRanges().forEach(range -> builder.add((Range)RangeSets.map(range, handler)));
        return builder.build();
    }

    public static <C extends Comparable<C>, R> R map(Range<C> range, Handler<C, R> handler) {
        if (range.hasLowerBound() && range.hasUpperBound()) {
            C lower = range.lowerEndpoint();
            C upper = range.upperEndpoint();
            if (range.lowerBoundType() == BoundType.OPEN) {
                if (range.upperBoundType() == BoundType.OPEN) {
                    return handler.open(lower, upper);
                }
                return handler.openClosed(lower, upper);
            }
            if (range.upperBoundType() == BoundType.OPEN) {
                return handler.closedOpen(lower, upper);
            }
            if (lower.equals(upper)) {
                return handler.singleton(lower);
            }
            return handler.closed(lower, upper);
        }
        if (range.hasLowerBound()) {
            C lower = range.lowerEndpoint();
            if (range.lowerBoundType() == BoundType.OPEN) {
                return handler.greaterThan(lower);
            }
            return handler.atLeast(lower);
        }
        if (range.hasUpperBound()) {
            C upper = range.upperEndpoint();
            if (range.upperBoundType() == BoundType.OPEN) {
                return handler.lessThan(upper);
            }
            return handler.atMost(upper);
        }
        return handler.all();
    }

    public static <C extends Comparable<C>, C2 extends Comparable<C2>> RangeSet<C2> copy(RangeSet<C> rangeSet, final Function<C, C2> map) {
        return RangeSets.map(rangeSet, new CopyingHandler<C, C2>(){

            @Override
            C2 convert(C c) {
                return (Comparable)map.apply(c);
            }
        });
    }

    public static <C extends Comparable<C>, C2 extends Comparable<C2>> Range<C2> copy(Range<C> range, final Function<C, C2> map) {
        return (Range)RangeSets.map(range, new CopyingHandler<C, C2>(){

            @Override
            C2 convert(C c) {
                return (Comparable)map.apply(c);
            }
        });
    }

    public static <C extends Comparable<C>> void forEach(RangeSet<C> rangeSet, Consumer<C> consumer) {
        rangeSet.asRanges().forEach(range -> RangeSets.forEach(range, consumer));
    }

    public static <C extends Comparable<C>> void forEach(Range<C> range, Consumer<C> consumer) {
        if (range.hasLowerBound() && range.hasUpperBound()) {
            C lower = range.lowerEndpoint();
            C upper = range.upperEndpoint();
            if (range.lowerBoundType() == BoundType.OPEN) {
                if (range.upperBoundType() == BoundType.OPEN) {
                    consumer.open(lower, upper);
                } else {
                    consumer.openClosed(lower, upper);
                }
            } else if (range.upperBoundType() == BoundType.OPEN) {
                consumer.closedOpen(lower, upper);
            } else if (lower.equals(upper)) {
                consumer.singleton(lower);
            } else {
                consumer.closed(lower, upper);
            }
        } else if (range.hasLowerBound()) {
            C lower = range.lowerEndpoint();
            if (range.lowerBoundType() == BoundType.OPEN) {
                consumer.greaterThan(lower);
            } else {
                consumer.atLeast(lower);
            }
        } else if (range.hasUpperBound()) {
            C upper = range.upperEndpoint();
            if (range.upperBoundType() == BoundType.OPEN) {
                consumer.lessThan(upper);
            } else {
                consumer.atMost(upper);
            }
        } else {
            consumer.all();
        }
    }

    public static <C extends Comparable<C>> Consumer<C> printer(StringBuilder sb, BiConsumer<StringBuilder, C> valuePrinter) {
        return new Printer<C>(sb, valuePrinter);
    }

    static class Printer<C extends Comparable<C>>
    implements Consumer<C> {
        private final StringBuilder sb;
        private final BiConsumer<StringBuilder, C> valuePrinter;

        Printer(StringBuilder sb, BiConsumer<StringBuilder, C> valuePrinter) {
            this.sb = sb;
            this.valuePrinter = valuePrinter;
        }

        @Override
        public void all() {
            this.sb.append("(-\u221e..+\u221e)");
        }

        @Override
        public void atLeast(C lower) {
            this.sb.append('[');
            this.valuePrinter.accept(this.sb, lower);
            this.sb.append("..+\u221e)");
        }

        @Override
        public void atMost(C upper) {
            this.sb.append("(-\u221e..");
            this.valuePrinter.accept(this.sb, upper);
            this.sb.append("]");
        }

        @Override
        public void greaterThan(C lower) {
            this.sb.append('(');
            this.valuePrinter.accept(this.sb, lower);
            this.sb.append("..+\u221e)");
        }

        @Override
        public void lessThan(C upper) {
            this.sb.append("(-\u221e..");
            this.valuePrinter.accept(this.sb, upper);
            this.sb.append(")");
        }

        @Override
        public void singleton(C value) {
            this.valuePrinter.accept(this.sb, value);
        }

        @Override
        public void closed(C lower, C upper) {
            this.sb.append('[');
            this.valuePrinter.accept(this.sb, lower);
            this.sb.append("..");
            this.valuePrinter.accept(this.sb, upper);
            this.sb.append(']');
        }

        @Override
        public void closedOpen(C lower, C upper) {
            this.sb.append('[');
            this.valuePrinter.accept(this.sb, lower);
            this.sb.append("..");
            this.valuePrinter.accept(this.sb, upper);
            this.sb.append(')');
        }

        @Override
        public void openClosed(C lower, C upper) {
            this.sb.append('(');
            this.valuePrinter.accept(this.sb, lower);
            this.sb.append("..");
            this.valuePrinter.accept(this.sb, upper);
            this.sb.append(']');
        }

        @Override
        public void open(C lower, C upper) {
            this.sb.append('(');
            this.valuePrinter.accept(this.sb, lower);
            this.sb.append("..");
            this.valuePrinter.accept(this.sb, upper);
            this.sb.append(')');
        }
    }

    private static abstract class CopyingHandler<C extends Comparable<C>, C2 extends Comparable<C2>>
    implements Handler<C, Range<C2>> {
        private CopyingHandler() {
        }

        abstract C2 convert(C var1);

        @Override
        public Range<C2> all() {
            return Range.all();
        }

        @Override
        public Range<C2> atLeast(C lower) {
            return Range.atLeast(this.convert(lower));
        }

        @Override
        public Range<C2> atMost(C upper) {
            return Range.atMost(this.convert(upper));
        }

        @Override
        public Range<C2> greaterThan(C lower) {
            return Range.greaterThan(this.convert(lower));
        }

        @Override
        public Range<C2> lessThan(C upper) {
            return Range.lessThan(this.convert(upper));
        }

        @Override
        public Range<C2> singleton(C value) {
            return Range.singleton(this.convert(value));
        }

        @Override
        public Range<C2> closed(C lower, C upper) {
            return Range.closed(this.convert(lower), this.convert(upper));
        }

        @Override
        public Range<C2> closedOpen(C lower, C upper) {
            return Range.closedOpen(this.convert(lower), this.convert(upper));
        }

        @Override
        public Range<C2> openClosed(C lower, C upper) {
            return Range.openClosed(this.convert(lower), this.convert(upper));
        }

        @Override
        public Range<C2> open(C lower, C upper) {
            return Range.open(this.convert(lower), this.convert(upper));
        }
    }

    public static interface Consumer<@NonNull V> {
        public void all();

        public void atLeast(V var1);

        public void atMost(V var1);

        public void greaterThan(V var1);

        public void lessThan(V var1);

        public void singleton(V var1);

        public void closed(V var1, V var2);

        public void closedOpen(V var1, V var2);

        public void openClosed(V var1, V var2);

        public void open(V var1, V var2);
    }

    private static class SinkConsumer<V, R>
    implements Consumer<V> {
        final Handler<V, R> handler;
        final java.util.function.Consumer<R> consumer;

        SinkConsumer(Handler<V, R> handler, java.util.function.Consumer<R> consumer) {
            this.handler = Objects.requireNonNull(handler, "handler");
            this.consumer = Objects.requireNonNull(consumer, "consumer");
        }

        @Override
        public void all() {
            this.consumer.accept(this.handler.all());
        }

        @Override
        public void atLeast(V lower) {
            this.consumer.accept(this.handler.atLeast(lower));
        }

        @Override
        public void atMost(V upper) {
            this.consumer.accept(this.handler.atMost(upper));
        }

        @Override
        public void greaterThan(V lower) {
            this.consumer.accept(this.handler.greaterThan(lower));
        }

        @Override
        public void lessThan(V upper) {
            this.consumer.accept(this.handler.lessThan(upper));
        }

        @Override
        public void singleton(V value) {
            this.consumer.accept(this.handler.singleton(value));
        }

        @Override
        public void closed(V lower, V upper) {
            this.consumer.accept(this.handler.closed(lower, upper));
        }

        @Override
        public void closedOpen(V lower, V upper) {
            this.consumer.accept(this.handler.closedOpen(lower, upper));
        }

        @Override
        public void openClosed(V lower, V upper) {
            this.consumer.accept(this.handler.openClosed(lower, upper));
        }

        @Override
        public void open(V lower, V upper) {
            this.consumer.accept(this.handler.open(lower, upper));
        }
    }

    public static interface Handler<V, R> {
        public R all();

        public R atLeast(V var1);

        public R atMost(V var1);

        public R greaterThan(V var1);

        public R lessThan(V var1);

        public R singleton(V var1);

        public R closed(V var1, V var2);

        public R closedOpen(V var1, V var2);

        public R openClosed(V var1, V var2);

        public R open(V var1, V var2);

        default public Consumer<V> andThen(java.util.function.Consumer<R> consumer) {
            return new SinkConsumer(this, consumer);
        }
    }
}

