/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.sql.type.SqlTypeAssignmentRule;
import org.apache.calcite.sql.type.SqlTypeCoercionRule;
import org.apache.calcite.sql.type.SqlTypeMappingRule;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;
import shaded.com.google.common.cache.CacheBuilder;
import shaded.com.google.common.cache.CacheLoader;
import shaded.com.google.common.cache.LoadingCache;
import shaded.com.google.common.collect.ImmutableSet;
import shaded.com.google.common.collect.Sets;
import shaded.com.google.common.util.concurrent.UncheckedExecutionException;

public abstract class SqlTypeMappingRules {
    public static SqlTypeMappingRule instance(boolean coerce) {
        if (coerce) {
            return SqlTypeCoercionRule.instance();
        }
        return SqlTypeAssignmentRule.instance();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        final Map<SqlTypeName, ImmutableSet<SqlTypeName>> map = new HashMap<SqlTypeName, ImmutableSet<SqlTypeName>>();
        final LoadingCache<Set<SqlTypeName>, ImmutableSet<SqlTypeName>> sets = CacheBuilder.newBuilder().build(CacheLoader.from(set -> Sets.immutableEnumSet(set)));

        Builder() {
        }

        void add(SqlTypeName toType, Set<SqlTypeName> fromTypes) {
            try {
                this.map.put(toType, this.sets.get(fromTypes));
            }
            catch (ExecutionException | UncheckedExecutionException e) {
                throw Util.throwAsRuntime("populating SqlTypeAssignmentRules", Util.causeOrSelf(e));
            }
        }

        void addAll(Map<SqlTypeName, ImmutableSet<SqlTypeName>> typeMapping) {
            try {
                this.map.putAll(typeMapping);
            }
            catch (UncheckedExecutionException e) {
                throw Util.throwAsRuntime("populating SqlTypeAssignmentRules", Util.causeOrSelf(e));
            }
        }

        ImmutableSet.Builder<SqlTypeName> copyValues(SqlTypeName typeName) {
            return ImmutableSet.builder().addAll(Nullness.castNonNull(this.map.get((Object)typeName)));
        }
    }
}

