/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public enum SqlTypeFamily implements RelDataTypeFamily
{
    CHARACTER,
    BINARY,
    NUMERIC,
    DATE,
    TIME,
    TIMESTAMP,
    BOOLEAN,
    INTERVAL_YEAR_MONTH,
    INTERVAL_DAY_TIME,
    STRING,
    APPROXIMATE_NUMERIC,
    EXACT_NUMERIC,
    DECIMAL,
    INTEGER,
    DATETIME,
    DATETIME_INTERVAL,
    MULTISET,
    ARRAY,
    MAP,
    NULL,
    ANY,
    CURSOR,
    COLUMN_LIST,
    GEO,
    FUNCTION,
    IGNORE;

    private static final Map<Integer, SqlTypeFamily> JDBC_TYPE_TO_FAMILY;

    public static @Nullable SqlTypeFamily getFamilyForJdbcType(int jdbcType) {
        return JDBC_TYPE_TO_FAMILY.get(jdbcType);
    }

    public List<SqlTypeFamily> allowableDifferenceTypes() {
        switch (this) {
            case NUMERIC: {
                return ImmutableList.of(NUMERIC);
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return ImmutableList.of(INTERVAL_DAY_TIME, INTERVAL_YEAR_MONTH);
            }
        }
        return ImmutableList.of();
    }

    public Collection<SqlTypeName> getTypeNames() {
        switch (this) {
            case CHARACTER: {
                return SqlTypeName.CHAR_TYPES;
            }
            case BINARY: {
                return SqlTypeName.BINARY_TYPES;
            }
            case NUMERIC: {
                return SqlTypeName.NUMERIC_TYPES;
            }
            case DECIMAL: {
                return ImmutableList.of(SqlTypeName.DECIMAL);
            }
            case DATE: {
                return ImmutableList.of(SqlTypeName.DATE);
            }
            case TIME: {
                return ImmutableList.of(SqlTypeName.TIME, SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE, SqlTypeName.TIME_TZ);
            }
            case TIMESTAMP: {
                return ImmutableList.of(SqlTypeName.TIMESTAMP, SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, SqlTypeName.TIMESTAMP_TZ);
            }
            case BOOLEAN: {
                return SqlTypeName.BOOLEAN_TYPES;
            }
            case INTERVAL_YEAR_MONTH: {
                return SqlTypeName.YEAR_INTERVAL_TYPES;
            }
            case INTERVAL_DAY_TIME: {
                return SqlTypeName.DAY_INTERVAL_TYPES;
            }
            case STRING: {
                return SqlTypeName.STRING_TYPES;
            }
            case APPROXIMATE_NUMERIC: {
                return SqlTypeName.APPROX_TYPES;
            }
            case EXACT_NUMERIC: {
                return SqlTypeName.EXACT_TYPES;
            }
            case INTEGER: {
                return SqlTypeName.INT_TYPES;
            }
            case DATETIME: {
                return SqlTypeName.DATETIME_TYPES;
            }
            case DATETIME_INTERVAL: {
                return SqlTypeName.INTERVAL_TYPES;
            }
            case GEO: {
                return SqlTypeName.GEOMETRY_TYPES;
            }
            case MULTISET: {
                return ImmutableList.of(SqlTypeName.MULTISET);
            }
            case ARRAY: {
                return ImmutableList.of(SqlTypeName.ARRAY);
            }
            case MAP: {
                return ImmutableList.of(SqlTypeName.MAP);
            }
            case NULL: {
                return ImmutableList.of(SqlTypeName.NULL);
            }
            case ANY: {
                return SqlTypeName.ALL_TYPES;
            }
            case CURSOR: {
                return ImmutableList.of(SqlTypeName.CURSOR);
            }
            case COLUMN_LIST: {
                return ImmutableList.of(SqlTypeName.COLUMN_LIST);
            }
            case FUNCTION: {
                return ImmutableList.of(SqlTypeName.FUNCTION);
            }
        }
        throw new IllegalArgumentException();
    }

    public @Nullable RelDataType getDefaultConcreteType(RelDataTypeFactory factory2) {
        switch (this) {
            case CHARACTER: {
                return factory2.createSqlType(SqlTypeName.VARCHAR);
            }
            case BINARY: {
                return factory2.createSqlType(SqlTypeName.VARBINARY);
            }
            case NUMERIC: {
                return SqlTypeUtil.getMaxPrecisionScaleDecimal(factory2);
            }
            case DATE: {
                return factory2.createSqlType(SqlTypeName.DATE);
            }
            case TIME: {
                return factory2.createSqlType(SqlTypeName.TIME);
            }
            case TIMESTAMP: {
                return factory2.createSqlType(SqlTypeName.TIMESTAMP);
            }
            case BOOLEAN: {
                return factory2.createSqlType(SqlTypeName.BOOLEAN);
            }
            case STRING: {
                return factory2.createSqlType(SqlTypeName.VARCHAR);
            }
            case APPROXIMATE_NUMERIC: {
                return factory2.createSqlType(SqlTypeName.DOUBLE);
            }
            case EXACT_NUMERIC: {
                return SqlTypeUtil.getMaxPrecisionScaleDecimal(factory2);
            }
            case INTEGER: {
                return factory2.createSqlType(SqlTypeName.BIGINT);
            }
            case DECIMAL: {
                return factory2.createSqlType(SqlTypeName.DECIMAL);
            }
            case DATETIME: {
                return factory2.createSqlType(SqlTypeName.TIMESTAMP);
            }
            case INTERVAL_DAY_TIME: {
                return factory2.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, SqlParserPos.ZERO));
            }
            case INTERVAL_YEAR_MONTH: {
                return factory2.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO));
            }
            case GEO: {
                return factory2.createSqlType(SqlTypeName.GEOMETRY);
            }
            case MULTISET: {
                return factory2.createMultisetType(factory2.createSqlType(SqlTypeName.ANY), -1L);
            }
            case ARRAY: {
                return factory2.createArrayType(factory2.createSqlType(SqlTypeName.ANY), -1L);
            }
            case MAP: {
                return factory2.createMapType(factory2.createSqlType(SqlTypeName.ANY), factory2.createSqlType(SqlTypeName.ANY));
            }
            case NULL: {
                return factory2.createSqlType(SqlTypeName.NULL);
            }
            case CURSOR: {
                return factory2.createSqlType(SqlTypeName.CURSOR);
            }
            case COLUMN_LIST: {
                return factory2.createSqlType(SqlTypeName.COLUMN_LIST);
            }
            case FUNCTION: {
                return factory2.createFunctionSqlType(factory2.createStructType(ImmutableList.of(), ImmutableList.of()), factory2.createSqlType(SqlTypeName.ANY));
            }
        }
        return null;
    }

    public boolean contains(RelDataType type2) {
        return SqlTypeUtil.isOfSameTypeName(this.getTypeNames(), type2);
    }

    static {
        JDBC_TYPE_TO_FAMILY = ImmutableMap.builder().put(-7, NUMERIC).put(-6, NUMERIC).put(5, NUMERIC).put(-5, NUMERIC).put(4, NUMERIC).put(2, NUMERIC).put(3, NUMERIC).put(6, NUMERIC).put(7, NUMERIC).put(8, NUMERIC).put(1, CHARACTER).put(12, CHARACTER).put(-1, CHARACTER).put(2005, CHARACTER).put(-2, BINARY).put(-3, BINARY).put(-4, BINARY).put(2004, BINARY).put(91, DATE).put(92, TIME).put(2013, TIME).put(93, TIMESTAMP).put(2014, TIMESTAMP).put(16, BOOLEAN).put(2012, CURSOR).put(2003, ARRAY).build();
    }
}

