/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import com.google.uzaygezen.core.BacktrackingQueryBuilder;
import com.google.uzaygezen.core.BitVector;
import com.google.uzaygezen.core.BitVectorFactories;
import com.google.uzaygezen.core.CompactHilbertCurve;
import com.google.uzaygezen.core.FilteredIndexRange;
import com.google.uzaygezen.core.LongContent;
import com.google.uzaygezen.core.PlainFilterCombiner;
import com.google.uzaygezen.core.Query;
import com.google.uzaygezen.core.SimpleRegionInspector;
import com.google.uzaygezen.core.ZoomingSpaceVisitorAdapter;
import com.google.uzaygezen.core.ranges.LongRange;
import com.google.uzaygezen.core.ranges.LongRangeHome;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.runtime.SpaceFillingCurve2D;
import shaded.com.google.common.collect.ImmutableList;

public class HilbertCurve2D
implements SpaceFillingCurve2D {
    final long precision;
    final CompactHilbertCurve chc;
    private final int resolution;

    public HilbertCurve2D(int resolution) {
        this.resolution = resolution;
        this.precision = (long)Math.pow(2.0, resolution);
        this.chc = new CompactHilbertCurve(new int[]{resolution, resolution});
    }

    long getNormalizedLongitude(double x) {
        return (long)((x + 180.0) * (double)(this.precision - 1L) / 360.0);
    }

    long getNormalizedLatitude(double y) {
        return (long)((y + 90.0) * (double)(this.precision - 1L) / 180.0);
    }

    long setNormalizedLatitude(long latNormal) {
        if (latNormal < 0L || latNormal > this.precision) {
            throw new NumberFormatException("Normalized latitude must be greater than 0 and less than the maximum precision");
        }
        return (long)((double)latNormal * 180.0 / (double)(this.precision - 1L));
    }

    long setNormalizedLongitude(long lonNormal) {
        if (lonNormal < 0L || lonNormal > this.precision) {
            throw new NumberFormatException("Normalized longitude must be greater than 0 and less than the maximum precision");
        }
        return (long)((double)lonNormal * 360.0 / (double)(this.precision - 1L));
    }

    @Override
    public long toIndex(double x, double y) {
        long normX = this.getNormalizedLongitude(x);
        long normY = this.getNormalizedLatitude(y);
        BitVector[] p = new BitVector[]{(BitVector)BitVectorFactories.OPTIMAL.apply(this.resolution), (BitVector)BitVectorFactories.OPTIMAL.apply(this.resolution)};
        p[0].copyFrom(normX);
        p[1].copyFrom(normY);
        BitVector hilbert = (BitVector)BitVectorFactories.OPTIMAL.apply(this.resolution * 2);
        this.chc.index(p, 0, hilbert);
        return hilbert.toLong();
    }

    @Override
    public SpaceFillingCurve2D.Point toPoint(long i) {
        BitVector h2 = (BitVector)BitVectorFactories.OPTIMAL.apply(this.resolution * 2);
        h2.copyFrom(i);
        BitVector[] p = new BitVector[]{(BitVector)BitVectorFactories.OPTIMAL.apply(this.resolution), (BitVector)BitVectorFactories.OPTIMAL.apply(this.resolution)};
        this.chc.indexInverse(h2, p);
        long x = this.setNormalizedLongitude(p[0].toLong()) - 180L;
        long y = this.setNormalizedLatitude(p[1].toLong()) - 90L;
        return new SpaceFillingCurve2D.Point(x, y);
    }

    @Override
    public List<SpaceFillingCurve2D.IndexRange> toRanges(double xMin, double yMin, double xMax, double yMax, SpaceFillingCurve2D.RangeComputeHints hints) {
        CompactHilbertCurve chc = new CompactHilbertCurve(new int[]{this.resolution, this.resolution});
        ArrayList<LongRange> region = new ArrayList<LongRange>();
        long minNormalizedLongitude = this.getNormalizedLongitude(xMin);
        long minNormalizedLatitude = this.getNormalizedLatitude(yMin);
        long maxNormalizedLongitude = this.getNormalizedLongitude(xMax);
        long maxNormalizedLatitude = this.getNormalizedLatitude(yMax);
        region.add(LongRange.of(minNormalizedLongitude, maxNormalizedLongitude));
        region.add(LongRange.of(minNormalizedLatitude, maxNormalizedLatitude));
        LongContent zero2 = new LongContent(0L);
        SimpleRegionInspector inspector = SimpleRegionInspector.create(ImmutableList.of(region), new LongContent(1L), range -> range, LongRangeHome.INSTANCE, zero2);
        PlainFilterCombiner combiner = new PlainFilterCombiner(LongRange.of(0L, 1L));
        BacktrackingQueryBuilder queryBuilder = BacktrackingQueryBuilder.create(inspector, combiner, Integer.MAX_VALUE, true, LongRangeHome.INSTANCE, zero2);
        chc.accept(new ZoomingSpaceVisitorAdapter(chc, queryBuilder));
        Object query = queryBuilder.get();
        List ranges = ((Query)query).getFilteredIndexRanges();
        ArrayList<SpaceFillingCurve2D.IndexRange> result2 = new ArrayList<SpaceFillingCurve2D.IndexRange>();
        for (FilteredIndexRange l : ranges) {
            LongRange range2 = (LongRange)l.getIndexRange();
            Long start = range2.getStart();
            Long end = range2.getEnd();
            boolean contained = l.isPotentialOverSelectivity();
            result2.add(0, SpaceFillingCurve2D.IndexRanges.create(start, end, contained));
        }
        return result2;
    }
}

