/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.prepare;

import java.io.Reader;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.CalciteSqlValidator;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.metadata.CachingRelMetadataProvider;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableList;

public class PlannerImpl
implements Planner,
RelOptTable.ViewExpander {
    private final SqlOperatorTable operatorTable;
    private final ImmutableList<Program> programs;
    private final @Nullable RelOptCostFactory costFactory;
    private final Context context;
    private final CalciteConnectionConfig connectionConfig;
    private final RelDataTypeSystem typeSystem;
    private final @Nullable ImmutableList<RelTraitDef> traitDefs;
    private final SqlParser.Config parserConfig;
    private final SqlValidator.Config sqlValidatorConfig;
    private final SqlToRelConverter.Config sqlToRelConverterConfig;
    private final SqlRexConvertletTable convertletTable;
    private State state;
    private boolean open;
    private final @Nullable SchemaPlus defaultSchema;
    private @Nullable JavaTypeFactory typeFactory;
    private @Nullable RelOptPlanner planner;
    private final @Nullable RexExecutor executor;
    private @Nullable SqlValidator validator;
    private @Nullable SqlNode validatedSqlNode;

    public PlannerImpl(FrameworkConfig config) {
        this.costFactory = config.getCostFactory();
        this.defaultSchema = config.getDefaultSchema();
        this.operatorTable = config.getOperatorTable();
        this.programs = config.getPrograms();
        this.parserConfig = config.getParserConfig();
        this.sqlValidatorConfig = config.getSqlValidatorConfig();
        this.sqlToRelConverterConfig = config.getSqlToRelConverterConfig();
        this.state = State.STATE_0_CLOSED;
        this.traitDefs = config.getTraitDefs();
        this.convertletTable = config.getConvertletTable();
        this.executor = config.getExecutor();
        this.context = config.getContext();
        this.connectionConfig = PlannerImpl.connConfig(this.context, this.parserConfig);
        this.typeSystem = config.getTypeSystem();
        this.reset();
    }

    private static CalciteConnectionConfig connConfig(Context context, SqlParser.Config parserConfig) {
        CalciteConnectionConfigImpl config = context.maybeUnwrap(CalciteConnectionConfigImpl.class).orElse(CalciteConnectionConfig.DEFAULT);
        if (!config.isSet(CalciteConnectionProperty.CASE_SENSITIVE)) {
            config = config.set(CalciteConnectionProperty.CASE_SENSITIVE, String.valueOf(parserConfig.caseSensitive()));
        }
        if (!config.isSet(CalciteConnectionProperty.CONFORMANCE)) {
            config = config.set(CalciteConnectionProperty.CONFORMANCE, String.valueOf(parserConfig.conformance()));
        }
        return config;
    }

    private void ensure(State state) {
        if (state == this.state) {
            return;
        }
        if (state.ordinal() < this.state.ordinal()) {
            throw new IllegalArgumentException("cannot move to " + (Object)((Object)state) + " from " + (Object)((Object)this.state));
        }
        state.from(this);
    }

    @Override
    public RelTraitSet getEmptyTraitSet() {
        return Objects.requireNonNull(this.planner, "planner").emptyTraitSet();
    }

    @Override
    public void close() {
        this.open = false;
        this.typeFactory = null;
        this.state = State.STATE_0_CLOSED;
    }

    @Override
    public void reset() {
        this.ensure(State.STATE_0_CLOSED);
        this.open = true;
        this.state = State.STATE_1_RESET;
    }

    private void ready() {
        switch (this.state) {
            case STATE_0_CLOSED: {
                this.reset();
                break;
            }
        }
        this.ensure(State.STATE_1_RESET);
        this.typeFactory = new JavaTypeFactoryImpl(this.typeSystem);
        this.planner = new VolcanoPlanner(this.costFactory, this.context);
        VolcanoPlanner planner = this.planner;
        RelOptUtil.registerDefaultRules(planner, this.connectionConfig.materializationsEnabled(), Hook.ENABLE_BINDABLE.get(false));
        planner.setExecutor(this.executor);
        this.state = State.STATE_2_READY;
        if (this.traitDefs == null) {
            planner.addRelTraitDef(ConventionTraitDef.INSTANCE);
            if (CalciteSystemProperty.ENABLE_COLLATION_TRAIT.value().booleanValue()) {
                planner.addRelTraitDef(RelCollationTraitDef.INSTANCE);
            }
        } else {
            for (RelTraitDef def : this.traitDefs) {
                planner.addRelTraitDef(def);
            }
        }
    }

    @Override
    public SqlNode parse(Reader reader) throws SqlParseException {
        switch (this.state) {
            case STATE_0_CLOSED: 
            case STATE_1_RESET: {
                this.ready();
                break;
            }
        }
        this.ensure(State.STATE_2_READY);
        SqlParser parser = SqlParser.create(reader, this.parserConfig);
        SqlNode sqlNode = parser.parseStmt();
        this.state = State.STATE_3_PARSED;
        return sqlNode;
    }

    @Override
    @EnsuresNonNull(value={"validator"})
    public SqlNode validate(SqlNode sqlNode) throws ValidationException {
        this.ensure(State.STATE_3_PARSED);
        this.validator = this.createSqlValidator(this.createCatalogReader());
        try {
            this.validatedSqlNode = this.validator.validate(sqlNode);
        }
        catch (RuntimeException e) {
            throw new ValidationException(e);
        }
        this.state = State.STATE_4_VALIDATED;
        return this.validatedSqlNode;
    }

    @Override
    public Pair<SqlNode, RelDataType> validateAndGetType(SqlNode sqlNode) throws ValidationException {
        SqlNode validatedNode = this.validate(sqlNode);
        RelDataType type2 = this.validator.getValidatedNodeType(validatedNode);
        return Pair.of(validatedNode, type2);
    }

    @Override
    public RelDataType getParameterRowType() {
        if (this.state.ordinal() < State.STATE_4_VALIDATED.ordinal()) {
            throw new RuntimeException("Need to call #validate() first");
        }
        return Objects.requireNonNull(this.validator, "validator").getParameterRowType(Objects.requireNonNull(this.validatedSqlNode, "validatedSqlNode"));
    }

    @Override
    public final RelNode convert(SqlNode sql) {
        return this.rel((SqlNode)sql).rel;
    }

    @Override
    public RelRoot rel(SqlNode sql) {
        this.ensure(State.STATE_4_VALIDATED);
        SqlNode validatedSqlNode = Objects.requireNonNull(this.validatedSqlNode, "validatedSqlNode is null. Need to call #validate() first");
        RexBuilder rexBuilder = this.createRexBuilder();
        RelOptCluster cluster = RelOptCluster.create(Objects.requireNonNull(this.planner, "planner"), rexBuilder);
        SqlToRelConverter.Config config = this.sqlToRelConverterConfig.withTrimUnusedFields(false);
        SqlToRelConverter sqlToRelConverter = new SqlToRelConverter((RelOptTable.ViewExpander)this, this.validator, (Prepare.CatalogReader)this.createCatalogReader(), cluster, this.convertletTable, config);
        RelRoot root = sqlToRelConverter.convertQuery(validatedSqlNode, false, true);
        root = root.withRel(sqlToRelConverter.flattenTypes(root.rel, true));
        RelBuilder relBuilder = config.getRelBuilderFactory().create(cluster, null);
        root = root.withRel(RelDecorrelator.decorrelateQuery(root.rel, relBuilder));
        this.state = State.STATE_5_CONVERTED;
        return root;
    }

    @Override
    public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath, @Nullable List<String> viewPath) {
        SqlNode sqlNode;
        RelOptPlanner planner = this.planner;
        if (planner == null) {
            this.ready();
            planner = Objects.requireNonNull(this.planner, "planner");
        }
        SqlParser parser = SqlParser.create(queryString, this.parserConfig);
        try {
            sqlNode = parser.parseQuery();
        }
        catch (SqlParseException e) {
            throw new RuntimeException("parse failed", e);
        }
        Prepare.CatalogReader catalogReader = this.createCatalogReader().withSchemaPath((List)schemaPath);
        SqlValidator validator = this.createSqlValidator((CalciteCatalogReader)catalogReader);
        RexBuilder rexBuilder = this.createRexBuilder();
        RelOptCluster cluster = RelOptCluster.create(planner, rexBuilder);
        SqlToRelConverter.Config config = this.sqlToRelConverterConfig.withTrimUnusedFields(false);
        SqlToRelConverter sqlToRelConverter = new SqlToRelConverter((RelOptTable.ViewExpander)this, validator, catalogReader, cluster, this.convertletTable, config);
        RelRoot root = sqlToRelConverter.convertQuery(sqlNode, true, false);
        RelRoot root2 = root.withRel(sqlToRelConverter.flattenTypes(root.rel, true));
        RelBuilder relBuilder = config.getRelBuilderFactory().create(cluster, null);
        return root2.withRel(RelDecorrelator.decorrelateQuery(root.rel, relBuilder));
    }

    private CalciteCatalogReader createCatalogReader() {
        SchemaPlus defaultSchema = Objects.requireNonNull(this.defaultSchema, "defaultSchema");
        SchemaPlus rootSchema = PlannerImpl.rootSchema(defaultSchema);
        return new CalciteCatalogReader(CalciteSchema.from(rootSchema), CalciteSchema.from(defaultSchema).path(null), this.getTypeFactory(), this.connectionConfig);
    }

    private SqlValidator createSqlValidator(CalciteCatalogReader catalogReader) {
        SqlOperatorTable opTab = SqlOperatorTables.chain(this.operatorTable, catalogReader);
        return new CalciteSqlValidator(opTab, catalogReader, this.getTypeFactory(), this.sqlValidatorConfig.withDefaultNullCollation(this.connectionConfig.defaultNullCollation()).withLenientOperatorLookup(this.connectionConfig.lenientOperatorLookup()).withConformance(this.connectionConfig.conformance()).withIdentifierExpansion(true));
    }

    private static SchemaPlus rootSchema(SchemaPlus schema) {
        SchemaPlus parentSchema;
        while ((parentSchema = schema.getParentSchema()) != null) {
            schema = parentSchema;
        }
        return schema;
    }

    private RexBuilder createRexBuilder() {
        return new RexBuilder(this.getTypeFactory());
    }

    @Override
    public JavaTypeFactory getTypeFactory() {
        return Objects.requireNonNull(this.typeFactory, "typeFactory");
    }

    @Override
    public RelNode transform(int ruleSetIndex, RelTraitSet requiredOutputTraits, RelNode rel) {
        this.ensure(State.STATE_5_CONVERTED);
        rel.getCluster().setMetadataProvider(new CachingRelMetadataProvider(Objects.requireNonNull(rel.getCluster().getMetadataProvider(), "metadataProvider"), rel.getCluster().getPlanner()));
        Program program = (Program)this.programs.get(ruleSetIndex);
        return program.run(Objects.requireNonNull(this.planner, "planner"), rel, requiredOutputTraits, ImmutableList.of(), ImmutableList.of());
    }

    private static enum State {
        STATE_0_CLOSED{

            @Override
            void from(PlannerImpl planner) {
                planner.close();
            }
        }
        ,
        STATE_1_RESET{

            @Override
            void from(PlannerImpl planner) {
                planner.ensure(2.STATE_0_CLOSED);
                planner.reset();
            }
        }
        ,
        STATE_2_READY{

            @Override
            void from(PlannerImpl planner) {
                STATE_1_RESET.from(planner);
                planner.ready();
            }
        }
        ,
        STATE_3_PARSED,
        STATE_4_VALIDATED,
        STATE_5_CONVERTED;


        void from(PlannerImpl planner) {
            throw new IllegalArgumentException("cannot move from " + (Object)((Object)planner.state) + " to " + (Object)((Object)this));
        }
    }

    @Deprecated
    public class ViewExpanderImpl
    implements RelOptTable.ViewExpander {
        ViewExpanderImpl() {
        }

        @Override
        public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath, @Nullable List<String> viewPath) {
            return PlannerImpl.this.expandView(rowType, queryString, schemaPath, viewPath);
        }
    }
}

