/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.sketches.quantiles.DoublesBufferAccessor;
import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.DoublesSketchAccessor;
import com.yahoo.sketches.quantiles.Util;

class DoublesPmfCdfImpl {
    DoublesPmfCdfImpl() {
    }

    static double[] getPMFOrCDF(DoublesSketch sketch, double[] splitPoints, boolean isCDF) {
        long[] counters = DoublesPmfCdfImpl.internalBuildHistogram(sketch, splitPoints);
        int numCounters = counters.length;
        double[] result2 = new double[numCounters];
        double n = sketch.getN();
        long subtotal = 0L;
        if (isCDF) {
            for (int j = 0; j < numCounters; ++j) {
                long count = counters[j];
                result2[j] = (double)(subtotal += count) / n;
            }
        } else {
            for (int j = 0; j < numCounters; ++j) {
                long count = counters[j];
                subtotal += count;
                result2[j] = (double)count / n;
            }
        }
        assert ((double)subtotal == n);
        return result2;
    }

    private static long[] internalBuildHistogram(DoublesSketch sketch, double[] splitPoints) {
        long myBitPattern;
        DoublesSketchAccessor sketchAccessor = DoublesSketchAccessor.wrap(sketch);
        Util.validateValues(splitPoints);
        int numSplitPoints = splitPoints.length;
        int numCounters = numSplitPoints + 1;
        long[] counters = new long[numCounters];
        long weight = 1L;
        sketchAccessor.setLevel(-1);
        if (numSplitPoints < 50) {
            DoublesPmfCdfImpl.bilinearTimeIncrementHistogramCounters(sketchAccessor, weight, splitPoints, counters);
        } else {
            sketchAccessor.sort();
            DoublesPmfCdfImpl.linearTimeIncrementHistogramCounters(sketchAccessor, weight, splitPoints, counters);
        }
        int k = sketch.getK();
        assert (myBitPattern == sketch.getN() / (2L * (long)k));
        int lvl = 0;
        for (myBitPattern = sketch.getBitPattern(); myBitPattern != 0L; myBitPattern >>>= 1) {
            weight += weight;
            if ((myBitPattern & 1L) > 0L) {
                sketchAccessor.setLevel(lvl);
                DoublesPmfCdfImpl.linearTimeIncrementHistogramCounters(sketchAccessor, weight, splitPoints, counters);
            }
            ++lvl;
        }
        return counters;
    }

    static void bilinearTimeIncrementHistogramCounters(DoublesBufferAccessor samples, long weight, double[] splitPoints, long[] counters) {
        assert (splitPoints.length + 1 == counters.length);
        for (int i = 0; i < samples.numItems(); ++i) {
            double splitpoint;
            int j;
            double sample = samples.get(i);
            for (j = 0; j < splitPoints.length && !(sample < (splitpoint = splitPoints[j])); ++j) {
            }
            assert (j < counters.length);
            int n = j;
            counters[n] = counters[n] + weight;
        }
    }

    static void linearTimeIncrementHistogramCounters(DoublesBufferAccessor samples, long weight, double[] splitPoints, long[] counters) {
        int i = 0;
        int j = 0;
        while (i < samples.numItems() && j < splitPoints.length) {
            if (samples.get(i) < splitPoints[j]) {
                int n = j;
                counters[n] = counters[n] + weight;
                ++i;
                continue;
            }
            ++j;
        }
        if (j == splitPoints.length) {
            int n = j;
            counters[n] = counters[n] + weight * (long)(samples.numItems() - i);
        }
    }
}

