/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public enum ClassLoaderHelper {


    public static URL getResource(String resource, Class<?> ... classes2) {
        return ClassLoaderHelper.getResource(resource, false, classes2);
    }

    public static URL getResource(String resource, boolean classesFirst, Class<?> ... classes2) {
        URL url;
        if (classesFirst) {
            url = ClassLoaderHelper.getResourceViaClasses(resource, classes2);
            if (url == null) {
                url = ClassLoaderHelper.getResourceViaContext(resource);
            }
        } else {
            url = ClassLoaderHelper.getResourceViaContext(resource);
            if (url == null) {
                url = ClassLoaderHelper.getResourceViaClasses(resource, classes2);
            }
        }
        return url == null ? ClassLoaderHelper.class.getResource(resource) : url;
    }

    private static URL getResourceViaClasses(String resource, Class<?>[] classes2) {
        if (classes2 != null) {
            for (Class<?> c : classes2) {
                URL url = c.getResource(resource);
                if (url == null) continue;
                return url;
            }
        }
        return null;
    }

    private static URL getResourceViaContext(String resource) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader == null ? null : loader.getResource(resource);
    }

    private static Class<?> loadClassViaClasses(String fqcn, Class<?>[] classes2) {
        if (classes2 != null) {
            for (Class<?> c : classes2) {
                ClassLoader loader = c.getClassLoader();
                if (loader == null) continue;
                try {
                    return loader.loadClass(fqcn);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static Class<?> loadClassViaContext(String fqcn) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return loader == null ? null : loader.loadClass(fqcn);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Class<?> loadClass(String fqcn, Class<?> ... classes2) throws ClassNotFoundException {
        return ClassLoaderHelper.loadClass(fqcn, true, classes2);
    }

    public static Class<?> loadClass(String fqcn, boolean classesFirst, Class<?> ... classes2) throws ClassNotFoundException {
        Class<?> target = null;
        if (classesFirst) {
            target = ClassLoaderHelper.loadClassViaClasses(fqcn, classes2);
            if (target == null) {
                target = ClassLoaderHelper.loadClassViaContext(fqcn);
            }
        } else {
            target = ClassLoaderHelper.loadClassViaContext(fqcn);
            if (target == null) {
                target = ClassLoaderHelper.loadClassViaClasses(fqcn, classes2);
            }
        }
        return target == null ? Class.forName(fqcn) : target;
    }

    public static InputStream getResourceAsStream(String resource, Class<?> ... classes2) {
        return ClassLoaderHelper.getResourceAsStream(resource, false, classes2);
    }

    public static InputStream getResourceAsStream(String resource, boolean classesFirst, Class<?> ... classes2) {
        URL url = ClassLoaderHelper.getResource(resource, classesFirst, classes2);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

