/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.model;

import com.amazonaws.encryptionsdk.EncryptedDataKey;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.ParseException;
import com.amazonaws.encryptionsdk.internal.PrimitivesParser;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class KeyBlob
implements EncryptedDataKey {
    private int keyProviderIdLen_ = -1;
    private byte[] keyProviderId_;
    private int keyProviderInfoLen_ = -1;
    private byte[] keyProviderInfo_;
    private int encryptedKeyLen_ = -1;
    private byte[] encryptedKey_;
    private boolean isComplete_ = false;

    public KeyBlob() {
    }

    public KeyBlob(String keyProviderId, byte[] keyProviderInfo, byte[] encryptedDataKey) {
        this.setEncryptedDataKey(encryptedDataKey);
        this.setKeyProviderId(keyProviderId);
        this.setKeyProviderInfo(keyProviderInfo);
    }

    public KeyBlob(EncryptedDataKey edk) {
        this.setEncryptedDataKey(edk.getEncryptedDataKey());
        String s2 = edk.getProviderId();
        this.setKeyProviderId(s2);
        this.setKeyProviderInfo(edk.getProviderInformation());
    }

    private int parseKeyProviderIdLen(byte[] b, int off) throws ParseException {
        this.keyProviderIdLen_ = PrimitivesParser.parseUnsignedShort(b, off);
        return 2;
    }

    private int parseKeyProviderId(byte[] b, int off) throws ParseException {
        int bytesToParseLen = b.length - off;
        if (bytesToParseLen >= this.keyProviderIdLen_) {
            this.keyProviderId_ = Arrays.copyOfRange(b, off, off + this.keyProviderIdLen_);
            return this.keyProviderIdLen_;
        }
        throw new ParseException("Not enough bytes to parse key provider id");
    }

    private int parseKeyProviderInfoLen(byte[] b, int off) throws ParseException {
        this.keyProviderInfoLen_ = PrimitivesParser.parseUnsignedShort(b, off);
        return 2;
    }

    private int parseKeyProviderInfo(byte[] b, int off) throws ParseException {
        int bytesToParseLen = b.length - off;
        if (bytesToParseLen >= this.keyProviderInfoLen_) {
            this.keyProviderInfo_ = Arrays.copyOfRange(b, off, off + this.keyProviderInfoLen_);
            return this.keyProviderInfoLen_;
        }
        throw new ParseException("Not enough bytes to parse key provider info");
    }

    private int parseKeyLen(byte[] b, int off) throws ParseException {
        this.encryptedKeyLen_ = PrimitivesParser.parseUnsignedShort(b, off);
        return 2;
    }

    private int parseKey(byte[] b, int off) throws ParseException {
        int bytesToParseLen = b.length - off;
        if (bytesToParseLen >= this.encryptedKeyLen_) {
            this.encryptedKey_ = Arrays.copyOfRange(b, off, off + this.encryptedKeyLen_);
            return this.encryptedKeyLen_;
        }
        throw new ParseException("Not enough bytes to parse key");
    }

    public int deserialize(byte[] b, int off) {
        if (b == null) {
            return 0;
        }
        int parsedBytes = 0;
        try {
            if (this.keyProviderIdLen_ < 0) {
                parsedBytes += this.parseKeyProviderIdLen(b, off + parsedBytes);
            }
            if (this.keyProviderId_ == null) {
                parsedBytes += this.parseKeyProviderId(b, off + parsedBytes);
            }
            if (this.keyProviderInfoLen_ < 0) {
                parsedBytes += this.parseKeyProviderInfoLen(b, off + parsedBytes);
            }
            if (this.keyProviderInfo_ == null) {
                parsedBytes += this.parseKeyProviderInfo(b, off + parsedBytes);
            }
            if (this.encryptedKeyLen_ < 0) {
                parsedBytes += this.parseKeyLen(b, off + parsedBytes);
            }
            if (this.encryptedKey_ == null) {
                parsedBytes += this.parseKey(b, off + parsedBytes);
            }
            this.isComplete_ = true;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return parsedBytes;
    }

    public byte[] toByteArray() {
        int outLen = 6 + this.keyProviderIdLen_ + this.keyProviderInfoLen_ + this.encryptedKeyLen_;
        ByteBuffer out = ByteBuffer.allocate(outLen);
        out.putShort((short)this.keyProviderIdLen_);
        out.put(this.keyProviderId_, 0, this.keyProviderIdLen_);
        out.putShort((short)this.keyProviderInfoLen_);
        out.put(this.keyProviderInfo_, 0, this.keyProviderInfoLen_);
        out.putShort((short)this.encryptedKeyLen_);
        out.put(this.encryptedKey_, 0, this.encryptedKeyLen_);
        return out.array();
    }

    public boolean isComplete() {
        return this.isComplete_;
    }

    public int getKeyProviderIdLen() {
        return this.keyProviderIdLen_;
    }

    @Override
    public String getProviderId() {
        String s2 = new String(this.keyProviderId_, StandardCharsets.UTF_8);
        return s2;
    }

    public int getKeyProviderInfoLen() {
        return this.keyProviderInfoLen_;
    }

    @Override
    public byte[] getProviderInformation() {
        return (byte[])this.keyProviderInfo_.clone();
    }

    public int getEncryptedDataKeyLen() {
        return this.encryptedKeyLen_;
    }

    @Override
    public byte[] getEncryptedDataKey() {
        return (byte[])this.encryptedKey_.clone();
    }

    public void setKeyProviderId(String keyProviderId) {
        byte[] keyProviderIdBytes = keyProviderId.getBytes(StandardCharsets.UTF_8);
        if (keyProviderIdBytes.length > 65535) {
            throw new AwsCryptoException("Key provider identifier length exceeds the max value of an unsigned short primitive.");
        }
        this.keyProviderId_ = keyProviderIdBytes;
        this.keyProviderIdLen_ = this.keyProviderId_.length;
    }

    public void setKeyProviderInfo(byte[] keyProviderInfo) {
        if (keyProviderInfo.length > 65535) {
            throw new AwsCryptoException("Key provider identifier information length exceeds the max value of an unsigned short primitive.");
        }
        this.keyProviderInfo_ = (byte[])keyProviderInfo.clone();
        this.keyProviderInfoLen_ = keyProviderInfo.length;
    }

    public void setEncryptedDataKey(byte[] encryptedDataKey) {
        if (encryptedDataKey.length > 65535) {
            throw new AwsCryptoException("Key length exceeds the max value of an unsigned short primitive.");
        }
        this.encryptedKey_ = (byte[])encryptedDataKey.clone();
        this.encryptedKeyLen_ = this.encryptedKey_.length;
    }
}

