/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.vectorvalues;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.FloatVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNVectorValuesIterator;
import org.opensearch.knn.index.vectorvalues.VectorValueExtractorStrategy;

public class KNNFloatVectorValues
extends KNNVectorValues<float[]> {
    KNNFloatVectorValues(KNNVectorValuesIterator vectorValuesIterator) {
        super(vectorValuesIterator);
    }

    @Override
    public float[] getVector() throws IOException {
        float[] vector = VectorValueExtractorStrategy.extractFloatVector(this.vectorValuesIterator);
        this.dimension = vector.length;
        this.bytesPerVector = vector.length * 4;
        return vector;
    }

    @Override
    public float[] conditionalCloneVector() throws IOException {
        float[] vector = this.getVector();
        if (this.vectorValuesIterator.getDocIdSetIterator() instanceof FloatVectorValues) {
            return Arrays.copyOf(vector, vector.length);
        }
        return vector;
    }
}

