"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ouiResizableButtonWithControls = ouiResizableButtonWithControls;
Object.defineProperty(exports, "EuiResizableButton", {
  enumerable: true,
  get: function get() {
    return _resizable_button.EuiResizableButton;
  }
});
Object.defineProperty(exports, "euiResizableButtonWithControls", {
  enumerable: true,
  get: function get() {
    return _resizable_button.euiResizableButtonWithControls;
  }
});
exports.OuiResizableButton = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _i18n = require("../i18n");

var _services = require("../../services");

var _context = require("./context");

var _resizable_button = require("../../eui_components/resizable_container/resizable_button");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var generatePanelId = (0, _services.htmlIdGenerator)('resizable-button');

var OuiResizableButton = function OuiResizableButton(_ref) {
  var isHorizontal = _ref.isHorizontal,
      className = _ref.className,
      id = _ref.id,
      registration = _ref.registration,
      disabled = _ref.disabled,
      onFocus = _ref.onFocus,
      onBlur = _ref.onBlur,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["isHorizontal", "className", "id", "registration", "disabled", "onFocus", "onBlur"]);
  var resizerId = (0, _react.useRef)(id || generatePanelId());

  var _useOuiResizableConta = (0, _context.useOuiResizableContainerContext)(),
      _useOuiResizableConta2 = _useOuiResizableConta.registry;

  _useOuiResizableConta2 = _useOuiResizableConta2 === void 0 ? {
    resizers: {}
  } : _useOuiResizableConta2;
  var resizers = _useOuiResizableConta2.resizers;
  var isDisabled = (0, _react.useMemo)(function () {
    return disabled || resizers[resizerId.current] && resizers[resizerId.current].isDisabled;
  }, [resizers, disabled]);
  var classes = (0, _classnames.default)('ouiResizableButton', {
    'ouiResizableButton--vertical': !isHorizontal,
    'ouiResizableButton--horizontal': isHorizontal,
    'ouiResizableButton--disabled': isDisabled
  }, className);
  var previousRef = (0, _react.useRef)();
  var onRef = (0, _react.useCallback)(function (ref) {
    if (!registration) return;
    var id = resizerId.current;

    if (ref) {
      previousRef.current = ref;
      registration.register({
        id: id,
        ref: ref,
        isFocused: false,
        isDisabled: disabled || false
      });
    } else {
      if (previousRef.current != null) {
        registration.deregister(id);
        previousRef.current = undefined;
      }
    }
  }, [registration, disabled]);

  var setFocus = function setFocus(e) {
    return e.currentTarget.focus();
  };

  var handleFocus = function handleFocus() {
    onFocus && onFocus(resizerId.current);
  };

  return /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
    tokens: ['ouiResizableButton.horizontalResizerAriaLabel', 'ouiResizableButton.verticalResizerAriaLabel'],
    defaults: ['Press left or right to adjust panels size', 'Press up or down to adjust panels size']
  }, function (_ref2) {
    var _ref3 = (0, _slicedToArray2.default)(_ref2, 2),
        horizontalResizerAriaLabel = _ref3[0],
        verticalResizerAriaLabel = _ref3[1];

    return /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
      id: resizerId.current,
      ref: onRef,
      "aria-label": isHorizontal ? horizontalResizerAriaLabel : verticalResizerAriaLabel,
      className: classes,
      "data-test-subj": "ouiResizableButton",
      type: "button",
      onClick: setFocus,
      onFocus: handleFocus,
      onBlur: onBlur,
      disabled: isDisabled
    }, rest));
  });
};

exports.OuiResizableButton = OuiResizableButton;
OuiResizableButton.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};

function ouiResizableButtonWithControls(controls) {
  return function (props) {
    return /*#__PURE__*/_react.default.createElement(OuiResizableButton, (0, _extends2.default)({}, controls, props));
  };
}
/* OUI -> EUI Aliases: Build-Time */

/* OUI -> EUI Aliases: Build-Time */