/*
  *
  * This file is a part of Libcsys.
  * Library for getting system resource information in real time.
  * Copyright 2019 CuboCore Group
  *
  *
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 3 of the License, or
  * (at your option) any later version.
  *
  *
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  *
  *
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, vsit http://www.gnu.org/licenses/.
  *
  */


#pragma once

#include <QtDBus>

#include "libcsys_global.h"

typedef QList<QDBusInterface *> PowerProviders;

class LIBCSYSSHARED_EXPORT Power : public QObject {
	Q_OBJECT

public:
	Power(QObject *parent = nullptr);
	~Power();

	bool systemCanSuspend();
	bool systemCanHibernate();
	bool systemCanReboot();
	bool systemCanHalt();

private:
	void createPowerProviders();

	PowerProviders providers;

public Q_SLOTS:
	bool systemSuspend();
	bool systemHibernate();
	bool systemReboot();
	bool systemHalt();
};
