/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;

public class CertificateAlgorithmId
implements CertAttrSet<String> {
    private AlgorithmId algId;
    public static final String IDENT = "x509.info.algorithmID";
    public static final String NAME = "algorithmID";
    public static final String ALGORITHM = "algorithm";

    public CertificateAlgorithmId(AlgorithmId algId) {
        this.algId = algId;
    }

    public CertificateAlgorithmId(DerInputStream in) throws IOException {
        DerValue val = in.getDerValue();
        this.algId = AlgorithmId.parse(val);
    }

    public CertificateAlgorithmId(InputStream in) throws IOException {
        DerValue val = new DerValue(in);
        this.algId = AlgorithmId.parse(val);
    }

    @Override
    public String toString() {
        if (this.algId == null) {
            return "";
        }
        return this.algId.toString() + ", OID = " + this.algId.getOID().toString() + "\n";
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.algId.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (!(obj instanceof AlgorithmId)) {
            throw new IOException("Attribute must be of type AlgorithmId.");
        }
        if (!name.equalsIgnoreCase(ALGORITHM)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateAlgorithmId.");
        }
        this.algId = (AlgorithmId)obj;
    }

    @Override
    public AlgorithmId get(String name) throws IOException {
        if (name.equalsIgnoreCase(ALGORITHM)) {
            return this.algId;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CertificateAlgorithmId.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(ALGORITHM)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateAlgorithmId.");
        }
        this.algId = null;
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(ALGORITHM);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

