/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.freeplane.core.util.Compat;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.explorer.AccessedNodes;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.FormulaDependencies;
import org.freeplane.plugin.script.NodeScript;
import org.freeplane.plugin.script.dependencies.RelatedElements;

public class ScriptContext
implements AccessedNodes {
    private final NodeScript nodeScript;
    private final RelatedElements relatedElements;

    public ScriptContext(NodeScript nodeScript) {
        this.nodeScript = nodeScript;
        this.relatedElements = nodeScript != null ? new RelatedElements(nodeScript.node) : null;
    }

    public NodeScript getNodeScript() {
        return this.nodeScript;
    }

    public URL getBaseUrl() {
        return this.nodeScript != null ? this.nodeScript.getBaseUrl() : null;
    }

    public File toAbsoluteFile(File file) {
        File absoluteFile;
        if (file.isAbsolute()) {
            absoluteFile = file;
        } else {
            URL baseUrl = this.getBaseUrl();
            if (baseUrl == null) {
                throw new IllegalStateException("Can not use relative files without base URL");
            }
            File parentFile = Compat.urlToFile((URL)baseUrl).getAbsoluteFile().getParentFile();
            absoluteFile = new File(parentFile, file.getPath());
        }
        return absoluteFile;
    }

    public URL toUrl(String path) {
        try {
            File file = new File(path);
            if (file.isAbsolute()) {
                return file.getCanonicalFile().toURL();
            }
            URL baseUrl = this.getBaseUrl();
            if (baseUrl != null) {
                return new URL(baseUrl, path);
            }
            return file.getCanonicalFile().toURL();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void accessAttribute(NodeModel accessedNode, Attribute accessedAttribute) {
        if (this.nodeScript != null) {
            this.relatedElements.relateAttribute(accessedNode, accessedAttribute);
        }
    }

    public void accessValue(NodeModel accessedNode) {
        if (this.nodeScript != null) {
            this.relatedElements.relateNode(accessedNode);
        }
    }

    public void accessNode(NodeModel accessedNode) {
        if (this.nodeScript != null) {
            FormulaDependencies.accessNode(this.nodeScript.node, accessedNode);
            this.relatedElements.relateMap(accessedNode.getMap());
        }
    }

    public void accessBranch(NodeModel accessedNode) {
        if (this.nodeScript != null) {
            FormulaDependencies.accessBranch(this.nodeScript.node, accessedNode);
        }
    }

    public void accessAll() {
        if (this.nodeScript != null) {
            FormulaDependencies.accessAll(this.nodeScript.node);
        }
    }

    public void accessGlobalNode() {
        if (this.nodeScript != null) {
            FormulaDependencies.accessGlobalNode(this.nodeScript.node);
        }
    }

    public RelatedElements getRelatedElements() {
        if (this.nodeScript != null) {
            return this.relatedElements;
        }
        throw new IllegalStateException("Accessed values not tracked without related node");
    }

    public String toString() {
        return this.nodeScript.toString();
    }
}

