/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.MapEditorController;
import net.sf.freecol.client.control.MapEditorTool;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.WrapLayout;
import net.sf.freecol.common.i18n.Messages;

public final class MapEditorToolboxPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(MapEditorToolboxPanel.class.getName());
    private final JPanel listPanel;
    private final ButtonGroup group;

    public MapEditorToolboxPanel(FreeColClient freeColClient) {
        super(freeColClient, null, new BorderLayout());
        Dimension terrainSize = ImageLibrary.scaleDimension(this.getImageLibrary().scale(ImageLibrary.TILE_OVERLAY_SIZE), 0.5f);
        this.listPanel = new JPanel(new WrapLayout().withForceComponentSize(terrainSize).withHorizontalAlignment(WrapLayout.HorizontalAlignment.LEFT).withHorizontalGap(WrapLayout.HorizontalGap.AUTO));
        this.group = new ButtonGroup();
        this.group.add(new JToggleButton());
        this.buildList();
        JScrollPane sl = new JScrollPane(this.listPanel, 20, 31);
        sl.getViewport().setOpaque(false);
        this.listPanel.setSize(new Dimension(terrainSize.width * 3, 0));
        this.add((Component)sl, "Center");
        this.setBorder(BorderFactory.createEmptyBorder());
        this.revalidate();
        this.repaint();
    }

    @Override
    public String getFrameTitle() {
        return Messages.message("mapEditor.toolBoxPanel.title");
    }

    @Override
    public SwingGUI.PopupPosition getFramePopupPosition() {
        return SwingGUI.PopupPosition.UPPER_RIGHT;
    }

    private void buildList() {
        MapEditorController ctlr = this.getFreeColClient().getMapEditorController();
        MapEditorTool defaultTool = ctlr.getCurrentTool();
        for (MapEditorTool mapEditorTool : MapEditorTool.values()) {
            boolean isDefaultTool = mapEditorTool == defaultTool;
            this.listPanel.add(this.buildButton(mapEditorTool, isDefaultTool));
        }
    }

    private JToggleButton buildButton(MapEditorTool mapEditorTool, boolean defaultTool) {
        String text = Messages.getName(mapEditorTool.getId());
        MapEditorController ctlr = this.getFreeColClient().getMapEditorController();
        Dimension riverSize = ImageLibrary.scaleDimension(this.getImageLibrary().scale(ImageLibrary.TILE_SIZE), 0.5f);
        ImageIcon icon = new ImageIcon(this.getImageLibrary().getScaledImage("image.ui.includesSpecification"));
        JToggleButton button = new JToggleButton(icon);
        button.setToolTipText(text);
        button.setOpaque(false);
        button.setSelected(defaultTool);
        this.group.add(button);
        button.addActionListener(ae -> {});
        button.setBorder(null);
        return button;
    }
}

