/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.scan;

import java.util.LinkedHashSet;
import java.util.Set;
import org.zaproxy.zap.scan.BaseScannerThread;
import org.zaproxy.zap.scan.ScanListener;
import org.zaproxy.zap.scan.ScanStartOptions;

public abstract class BaseContextScannerThread<StartOptions extends ScanStartOptions, Listener extends ScanListener>
extends BaseScannerThread<StartOptions> {
    protected Set<Listener> listeners;
    protected int contextId;

    public BaseContextScannerThread(int contextId) {
        this.contextId = contextId;
        this.listeners = new LinkedHashSet<Listener>();
    }

    public void addScanListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeScanListener(Listener l) {
        this.listeners.remove(l);
    }

    protected void notifyScanStarted() {
        for (ScanListener l : this.listeners) {
            l.scanStarted(this.contextId);
        }
    }

    protected void notifyScanFinished() {
        for (ScanListener l : this.listeners) {
            l.scanFinished(this.contextId);
        }
    }

    protected void notifyScanProgress() {
        for (ScanListener l : this.listeners) {
            l.scanProgress(this.contextId, this.getScanProgress(), this.getScanMaximumProgress());
        }
    }

    @Override
    public void setScanProgress(int progress) {
        super.setScanProgress(progress);
        this.notifyScanProgress();
    }
}

